/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class Node<T> {
    private T value;
    private String name;
    private Node<T> parent;
    private Map<String, Node<T>> children;

    Node() {
    }

    Node(T value) {
        this.value = value;
    }

    Node<T> addChild(String token) {
        return this.addChild(token, null);
    }

    Node<T> addChild(String token, T value) {
        Node<T> child;
        if (this.children == null) {
            this.children = new ConcurrentHashMap<String, Node<T>>();
        }
        if ((child = this.children.get(token)) == null) {
            child = new Node<T>(value);
            child.name = token;
            child.parent = this;
            this.children.put(token, child);
        }
        return child;
    }

    Node<T> getChild(String token) {
        return this.children != null ? this.children.get(token) : null;
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value) {
        this.value = value;
    }

    boolean isEmpty() {
        return this.children == null || this.children.isEmpty();
    }

    void remove() {
        Map<String, Node<T>> nodes;
        this.setValue(null);
        if (this.parent != null && (nodes = this.parent.children) != null) {
            nodes.remove(this.name);
        }
    }
}

