/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.client.entity;

import com.redhat.ceylon.aether.apache.http.annotation.NotThreadSafe;
import com.redhat.ceylon.aether.apache.http.client.entity.DecompressingEntity;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
class LazyDecompressingInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final DecompressingEntity decompressingEntity;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream wrappedStream, DecompressingEntity decompressingEntity) {
        this.wrappedStream = wrappedStream;
        this.decompressingEntity = decompressingEntity;
    }

    public int read() throws IOException {
        this.initWrapper();
        return this.wrapperStream.read();
    }

    public int available() throws IOException {
        this.initWrapper();
        return this.wrapperStream.available();
    }

    private void initWrapper() throws IOException {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.decompressingEntity.decorate(this.wrappedStream);
        }
    }

    public void close() throws IOException {
        if (this.wrapperStream != null) {
            this.wrapperStream.close();
        }
        this.wrappedStream.close();
    }
}

