/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.client.protocol;

import com.redhat.ceylon.aether.apache.http.HttpEntity;
import com.redhat.ceylon.aether.apache.http.HttpEntityEnclosingRequest;
import com.redhat.ceylon.aether.apache.http.HttpException;
import com.redhat.ceylon.aether.apache.http.HttpRequest;
import com.redhat.ceylon.aether.apache.http.HttpRequestInterceptor;
import com.redhat.ceylon.aether.apache.http.HttpVersion;
import com.redhat.ceylon.aether.apache.http.ProtocolVersion;
import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.client.config.RequestConfig;
import com.redhat.ceylon.aether.apache.http.client.protocol.HttpClientContext;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import com.redhat.ceylon.aether.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

