/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl;

import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.HttpResponseFactory;
import com.redhat.ceylon.aether.apache.http.ProtocolVersion;
import com.redhat.ceylon.aether.apache.http.ReasonPhraseCatalog;
import com.redhat.ceylon.aether.apache.http.StatusLine;
import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.impl.EnglishReasonPhraseCatalog;
import com.redhat.ceylon.aether.apache.http.message.BasicHttpResponse;
import com.redhat.ceylon.aether.apache.http.message.BasicStatusLine;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import com.redhat.ceylon.aether.apache.http.util.Args;
import java.util.Locale;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

