/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.conn;

import com.redhat.ceylon.aether.apache.http.HttpRequest;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.annotation.NotThreadSafe;
import com.redhat.ceylon.aether.apache.http.config.MessageConstraints;
import com.redhat.ceylon.aether.apache.http.conn.ManagedHttpClientConnection;
import com.redhat.ceylon.aether.apache.http.entity.ContentLengthStrategy;
import com.redhat.ceylon.aether.apache.http.impl.DefaultBHttpClientConnection;
import com.redhat.ceylon.aether.apache.http.io.HttpMessageParserFactory;
import com.redhat.ceylon.aether.apache.http.io.HttpMessageWriterFactory;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultManagedHttpClientConnection
extends DefaultBHttpClientConnection
implements ManagedHttpClientConnection,
HttpContext {
    private final String id;
    private final Map<String, Object> attributes;
    private volatile boolean shutdown;

    public DefaultManagedHttpClientConnection(String id, int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.id = id;
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    public DefaultManagedHttpClientConnection(String id, int buffersize) {
        this(id, buffersize, buffersize, null, null, null, null, null, null, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown = true;
        super.shutdown();
    }

    @Override
    public Object getAttribute(String id) {
        return this.attributes.get(id);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.attributes.remove(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.attributes.put(id, obj);
    }

    @Override
    public void bind(Socket socket) throws IOException {
        if (this.shutdown) {
            socket.close();
            throw new InterruptedIOException("Connection already shutdown");
        }
        super.bind(socket);
    }

    @Override
    public Socket getSocket() {
        return super.getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        Socket socket = super.getSocket();
        if (socket instanceof SSLSocket) {
            return ((SSLSocket)socket).getSession();
        }
        return null;
    }
}

