/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.conn;

import com.redhat.ceylon.aether.apache.http.HttpException;
import com.redhat.ceylon.aether.apache.http.HttpHost;
import com.redhat.ceylon.aether.apache.http.HttpRequest;
import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.client.config.RequestConfig;
import com.redhat.ceylon.aether.apache.http.client.protocol.HttpClientContext;
import com.redhat.ceylon.aether.apache.http.conn.SchemePortResolver;
import com.redhat.ceylon.aether.apache.http.conn.UnsupportedSchemeException;
import com.redhat.ceylon.aether.apache.http.conn.routing.HttpRoute;
import com.redhat.ceylon.aether.apache.http.conn.routing.HttpRoutePlanner;
import com.redhat.ceylon.aether.apache.http.impl.conn.DefaultSchemePortResolver;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import com.redhat.ceylon.aether.apache.http.util.Args;
import java.net.InetAddress;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(host, "Target host");
        Args.notNull(request, "Request");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

