/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.cookie;

import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.cookie.Cookie;
import com.redhat.ceylon.aether.apache.http.cookie.CookieOrigin;
import com.redhat.ceylon.aether.apache.http.cookie.CookieRestrictionViolationException;
import com.redhat.ceylon.aether.apache.http.cookie.MalformedCookieException;
import com.redhat.ceylon.aether.apache.http.cookie.SetCookie;
import com.redhat.ceylon.aether.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.redhat.ceylon.aether.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

