/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.cookie;

import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.cookie.CookieSpec;
import com.redhat.ceylon.aether.apache.http.cookie.CookieSpecFactory;
import com.redhat.ceylon.aether.apache.http.cookie.CookieSpecProvider;
import com.redhat.ceylon.aether.apache.http.impl.cookie.RFC2965Spec;
import com.redhat.ceylon.aether.apache.http.params.HttpParams;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import java.util.Collection;

@Immutable
public class RFC2965SpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    private final String[] datepatterns;
    private final boolean oneHeader;

    public RFC2965SpecFactory(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public RFC2965SpecFactory() {
        this(null, false);
    }

    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            boolean singleHeader = params.getBooleanParameter("http.protocol.single-cookie-header", false);
            return new RFC2965Spec(patterns, singleHeader);
        }
        return new RFC2965Spec();
    }

    public CookieSpec create(HttpContext context) {
        return new RFC2965Spec(this.datepatterns, this.oneHeader);
    }
}

