/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.cookie;

import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.cookie.ClientCookie;
import com.redhat.ceylon.aether.apache.http.cookie.Cookie;
import com.redhat.ceylon.aether.apache.http.cookie.CookieAttributeHandler;
import com.redhat.ceylon.aether.apache.http.cookie.CookieOrigin;
import com.redhat.ceylon.aether.apache.http.cookie.CookieRestrictionViolationException;
import com.redhat.ceylon.aether.apache.http.cookie.MalformedCookieException;
import com.redhat.ceylon.aether.apache.http.cookie.SetCookie;
import com.redhat.ceylon.aether.apache.http.cookie.SetCookie2;
import com.redhat.ceylon.aether.apache.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version2 = -1;
        try {
            version2 = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version2 = -1;
        }
        if (version2 < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version2);
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }
}

