/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.execchain;

import com.redhat.ceylon.aether.apache.commons.logging.Log;
import com.redhat.ceylon.aether.apache.commons.logging.LogFactory;
import com.redhat.ceylon.aether.apache.http.ConnectionReuseStrategy;
import com.redhat.ceylon.aether.apache.http.HttpClientConnection;
import com.redhat.ceylon.aether.apache.http.HttpEntity;
import com.redhat.ceylon.aether.apache.http.HttpException;
import com.redhat.ceylon.aether.apache.http.HttpHost;
import com.redhat.ceylon.aether.apache.http.HttpRequest;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.ProtocolException;
import com.redhat.ceylon.aether.apache.http.annotation.Immutable;
import com.redhat.ceylon.aether.apache.http.client.config.RequestConfig;
import com.redhat.ceylon.aether.apache.http.client.methods.CloseableHttpResponse;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpExecutionAware;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpRequestWrapper;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpUriRequest;
import com.redhat.ceylon.aether.apache.http.client.protocol.HttpClientContext;
import com.redhat.ceylon.aether.apache.http.client.protocol.RequestClientConnControl;
import com.redhat.ceylon.aether.apache.http.client.utils.URIUtils;
import com.redhat.ceylon.aether.apache.http.conn.ConnectionKeepAliveStrategy;
import com.redhat.ceylon.aether.apache.http.conn.ConnectionRequest;
import com.redhat.ceylon.aether.apache.http.conn.HttpClientConnectionManager;
import com.redhat.ceylon.aether.apache.http.conn.routing.HttpRoute;
import com.redhat.ceylon.aether.apache.http.impl.conn.ConnectionShutdownException;
import com.redhat.ceylon.aether.apache.http.impl.execchain.ClientExecChain;
import com.redhat.ceylon.aether.apache.http.impl.execchain.ConnectionHolder;
import com.redhat.ceylon.aether.apache.http.impl.execchain.Proxies;
import com.redhat.ceylon.aether.apache.http.impl.execchain.RequestAbortedException;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import com.redhat.ceylon.aether.apache.http.protocol.HttpProcessor;
import com.redhat.ceylon.aether.apache.http.protocol.HttpRequestExecutor;
import com.redhat.ceylon.aether.apache.http.protocol.ImmutableHttpProcessor;
import com.redhat.ceylon.aether.apache.http.protocol.RequestContent;
import com.redhat.ceylon.aether.apache.http.protocol.RequestTargetHost;
import com.redhat.ceylon.aether.apache.http.protocol.RequestUserAgent;
import com.redhat.ceylon.aether.apache.http.util.Args;
import com.redhat.ceylon.aether.apache.http.util.VersionInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Immutable
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "com.redhat.ceylon.aether.apache.http.client", this.getClass())));
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper request, HttpRoute route) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (uri != null) {
                uri = uri.isAbsolute() ? URIUtils.rewriteURI(uri, null, true) : URIUtils.rewriteURI(uri);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), ex);
        }
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        MinimalClientExec.rewriteRequestURI(request, route);
        ConnectionRequest connRequest = this.connManager.requestConnection(route, null);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config = context.getRequestConfig();
        try {
            int timeout = config.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout > 0 ? (long)timeout : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        ConnectionHolder releaseTrigger = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            URI uri;
            int timeout;
            if (execAware != null) {
                if (execAware.isAborted()) {
                    releaseTrigger.close();
                    throw new RequestAbortedException("Request aborted");
                }
                execAware.setCancellable(releaseTrigger);
            }
            if (!managedConn.isOpen()) {
                timeout = config.getConnectTimeout();
                this.connManager.connect(managedConn, route, timeout > 0 ? timeout : 0, context);
                this.connManager.routeComplete(managedConn, route, context);
            }
            if ((timeout = config.getSocketTimeout()) >= 0) {
                managedConn.setSocketTimeout(timeout);
            }
            HttpHost target = null;
            HttpRequest original = request.getOriginal();
            if (original instanceof HttpUriRequest && (uri = ((HttpUriRequest)original).getURI()).isAbsolute()) {
                target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            }
            if (target == null) {
                target = route.getTargetHost();
            }
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.request", request);
            context.setAttribute("http.connection", managedConn);
            context.setAttribute("http.route", route);
            this.httpProcessor.process(request, (HttpContext)context);
            HttpResponse response = this.requestExecutor.execute(request, managedConn, context);
            this.httpProcessor.process(response, (HttpContext)context);
            if (this.reuseStrategy.keepAlive(response, context)) {
                long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                releaseTrigger.setValidFor(duration, TimeUnit.MILLISECONDS);
                releaseTrigger.markReusable();
            } else {
                releaseTrigger.markNonReusable();
            }
            HttpEntity entity = response.getEntity();
            if (entity == null || !entity.isStreaming()) {
                releaseTrigger.releaseConnection();
                return Proxies.enhanceResponse(response, null);
            }
            return Proxies.enhanceResponse(response, releaseTrigger);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
        catch (RuntimeException ex) {
            releaseTrigger.abortConnection();
            throw ex;
        }
    }
}

