/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.io;

import com.redhat.ceylon.aether.apache.http.Header;
import com.redhat.ceylon.aether.apache.http.HeaderIterator;
import com.redhat.ceylon.aether.apache.http.HttpException;
import com.redhat.ceylon.aether.apache.http.HttpMessage;
import com.redhat.ceylon.aether.apache.http.annotation.NotThreadSafe;
import com.redhat.ceylon.aether.apache.http.io.HttpMessageWriter;
import com.redhat.ceylon.aether.apache.http.io.SessionOutputBuffer;
import com.redhat.ceylon.aether.apache.http.message.BasicLineFormatter;
import com.redhat.ceylon.aether.apache.http.message.LineFormatter;
import com.redhat.ceylon.aether.apache.http.params.HttpParams;
import com.redhat.ceylon.aether.apache.http.util.Args;
import com.redhat.ceylon.aether.apache.http.util.CharArrayBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

