/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.http.impl.io;

import com.redhat.ceylon.aether.apache.http.HttpException;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.HttpResponseFactory;
import com.redhat.ceylon.aether.apache.http.NoHttpResponseException;
import com.redhat.ceylon.aether.apache.http.ParseException;
import com.redhat.ceylon.aether.apache.http.StatusLine;
import com.redhat.ceylon.aether.apache.http.annotation.NotThreadSafe;
import com.redhat.ceylon.aether.apache.http.config.MessageConstraints;
import com.redhat.ceylon.aether.apache.http.impl.DefaultHttpResponseFactory;
import com.redhat.ceylon.aether.apache.http.impl.io.AbstractMessageParser;
import com.redhat.ceylon.aether.apache.http.io.SessionInputBuffer;
import com.redhat.ceylon.aether.apache.http.message.LineParser;
import com.redhat.ceylon.aether.apache.http.message.ParserCursor;
import com.redhat.ceylon.aether.apache.http.params.HttpParams;
import com.redhat.ceylon.aether.apache.http.util.Args;
import com.redhat.ceylon.aether.apache.http.util.CharArrayBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

