/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.model;

import com.redhat.ceylon.aether.apache.maven.model.InputLocation;
import com.redhat.ceylon.aether.apache.maven.model.InputLocationTracker;
import com.redhat.ceylon.aether.codehaus.plexus.util.xml.Xpp3Dom;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigurationContainer
implements Serializable,
Cloneable,
InputLocationTracker {
    private String inherited;
    private Object configuration;
    private Map<Object, InputLocation> locations;
    private boolean inheritanceApplied = true;

    public ConfigurationContainer clone() {
        try {
            ConfigurationContainer copy = (ConfigurationContainer)super.clone();
            if (this.configuration != null) {
                copy.configuration = new Xpp3Dom((Xpp3Dom)this.configuration);
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getInherited() {
        return this.inherited;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
    }

    public void setInherited(String inherited) {
        this.inherited = inherited;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public boolean isInherited() {
        return this.inherited != null ? Boolean.parseBoolean(this.inherited) : true;
    }

    public void setInherited(boolean inherited) {
        this.inherited = String.valueOf(inherited);
    }

    public void unsetInheritanceApplied() {
        this.inheritanceApplied = false;
    }

    public boolean isInheritanceApplied() {
        return this.inheritanceApplied;
    }
}

