/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.model.plugin;

import com.redhat.ceylon.aether.apache.maven.model.Build;
import com.redhat.ceylon.aether.apache.maven.model.Model;
import com.redhat.ceylon.aether.apache.maven.model.Plugin;
import com.redhat.ceylon.aether.apache.maven.model.PluginExecution;
import com.redhat.ceylon.aether.apache.maven.model.PluginManagement;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelBuildingRequest;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelProblemCollector;
import com.redhat.ceylon.aether.apache.maven.model.plugin.PluginConfigurationExpander;
import com.redhat.ceylon.aether.codehaus.plexus.component.annotations.Component;
import com.redhat.ceylon.aether.codehaus.plexus.util.xml.Xpp3Dom;
import java.util.List;

@Component(role=PluginConfigurationExpander.class)
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Build build = model.getBuild();
        if (build != null) {
            this.expand(build.getPlugins());
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                this.expand(pluginManagement.getPlugins());
            }
        }
    }

    private void expand(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
            if (pluginConfiguration == null) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom executionConfiguration = (Xpp3Dom)execution.getConfiguration();
                executionConfiguration = Xpp3Dom.mergeXpp3Dom(executionConfiguration, new Xpp3Dom(pluginConfiguration));
                execution.setConfiguration(executionConfiguration);
            }
        }
    }
}

