/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.model.superpom;

import com.redhat.ceylon.aether.apache.maven.model.Model;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelProcessor;
import com.redhat.ceylon.aether.apache.maven.model.superpom.SuperPomProvider;
import com.redhat.ceylon.aether.codehaus.plexus.component.annotations.Component;
import com.redhat.ceylon.aether.codehaus.plexus.component.annotations.Requirement;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

@Component(role=SuperPomProvider.class)
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private Model superModel;
    @Requirement
    private ModelProcessor modelProcessor;

    public DefaultSuperPomProvider setModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        return this;
    }

    @Override
    public Model getSuperModel(String version2) {
        if (this.superModel == null) {
            String resource = "/com/redhat/ceylon/aether/apache/maven/model/pom-" + version2 + ".xml";
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalStateException("The super POM " + resource + " was not found" + ", please verify the integrity of your Maven installation");
            }
            try {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("xml:4.0.0", "xml:4.0.0");
                this.superModel = this.modelProcessor.read(is, options);
            }
            catch (IOException e) {
                throw new IllegalStateException("The super POM " + resource + " is damaged" + ", please verify the integrity of your Maven installation", e);
            }
        }
        return this.superModel;
    }
}

