/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.repository.internal;

import com.redhat.ceylon.aether.apache.commons.lang3.Validate;
import com.redhat.ceylon.aether.apache.maven.model.DistributionManagement;
import com.redhat.ceylon.aether.apache.maven.model.Model;
import com.redhat.ceylon.aether.apache.maven.model.Relocation;
import com.redhat.ceylon.aether.apache.maven.model.building.DefaultModelBuilderFactory;
import com.redhat.ceylon.aether.apache.maven.model.building.DefaultModelBuildingRequest;
import com.redhat.ceylon.aether.apache.maven.model.building.FileModelSource;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelBuilder;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelBuildingException;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelProblem;
import com.redhat.ceylon.aether.apache.maven.model.resolution.UnresolvableModelException;
import com.redhat.ceylon.aether.apache.maven.repository.internal.ArtifactDescriptorReaderDelegate;
import com.redhat.ceylon.aether.apache.maven.repository.internal.ArtifactDescriptorUtils;
import com.redhat.ceylon.aether.apache.maven.repository.internal.DefaultModelCache;
import com.redhat.ceylon.aether.apache.maven.repository.internal.DefaultModelResolver;
import com.redhat.ceylon.aether.apache.maven.repository.internal.MavenWorkspaceReader;
import com.redhat.ceylon.aether.apache.maven.repository.internal.RelocatedArtifact;
import com.redhat.ceylon.aether.codehaus.plexus.component.annotations.Component;
import com.redhat.ceylon.aether.codehaus.plexus.component.annotations.Requirement;
import com.redhat.ceylon.aether.eclipse.aether.RepositoryEvent;
import com.redhat.ceylon.aether.eclipse.aether.RepositoryException;
import com.redhat.ceylon.aether.eclipse.aether.RepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.RequestTrace;
import com.redhat.ceylon.aether.eclipse.aether.artifact.Artifact;
import com.redhat.ceylon.aether.eclipse.aether.impl.ArtifactDescriptorReader;
import com.redhat.ceylon.aether.eclipse.aether.impl.ArtifactResolver;
import com.redhat.ceylon.aether.eclipse.aether.impl.RemoteRepositoryManager;
import com.redhat.ceylon.aether.eclipse.aether.impl.RepositoryEventDispatcher;
import com.redhat.ceylon.aether.eclipse.aether.impl.VersionRangeResolver;
import com.redhat.ceylon.aether.eclipse.aether.impl.VersionResolver;
import com.redhat.ceylon.aether.eclipse.aether.repository.WorkspaceReader;
import com.redhat.ceylon.aether.eclipse.aether.repository.WorkspaceRepository;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactDescriptorException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactDescriptorRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactDescriptorResult;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactResult;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionResult;
import com.redhat.ceylon.aether.eclipse.aether.spi.locator.Service;
import com.redhat.ceylon.aether.eclipse.aether.spi.locator.ServiceLocator;
import com.redhat.ceylon.aether.eclipse.aether.spi.log.Logger;
import com.redhat.ceylon.aether.eclipse.aether.spi.log.LoggerFactory;
import com.redhat.ceylon.aether.eclipse.aether.spi.log.NullLoggerFactory;
import com.redhat.ceylon.aether.eclipse.aether.transfer.ArtifactNotFoundException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@Component(role=ArtifactDescriptorReader.class)
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private VersionRangeResolver versionRangeResolver;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private ModelBuilder modelBuilder;

    public DefaultArtifactDescriptorReader() {
    }

    @Inject
    DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
    }

    public DefaultArtifactDescriptorReader setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Validate.notNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Validate.notNull(versionResolver, "versionResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Validate.notNull(versionRangeResolver, "versionRangeResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Validate.notNull(artifactResolver, "artifactResolver cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Validate.notNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null", new Object[0]);
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = Validate.notNull(modelBuilder, "modelBuilder cannot be null", new Object[0]);
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            Map<String, Object> config = session.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = new ArtifactDescriptorReaderDelegate();
            }
            delegate.populateResult(session, result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Artifact a = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add(a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, a, exception);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, a, (Exception)e.getCause());
                    if ((this.getPolicy(session, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session));
                modelRequest.setModelResolver(new DefaultModelResolver(session, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, a, e);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result.addRelocation(a);
            a = new RelocatedArtifact(a, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion());
            result.setArtifact(a);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMngt = model.getDistributionManagement();
        if (distMngt != null) {
            relocation = distMngt.getRelocation();
        }
        return relocation;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

