/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.repository.internal;

import com.redhat.ceylon.aether.apache.maven.model.Parent;
import com.redhat.ceylon.aether.apache.maven.model.Repository;
import com.redhat.ceylon.aether.apache.maven.model.building.FileModelSource;
import com.redhat.ceylon.aether.apache.maven.model.building.ModelSource;
import com.redhat.ceylon.aether.apache.maven.model.resolution.InvalidRepositoryException;
import com.redhat.ceylon.aether.apache.maven.model.resolution.ModelResolver;
import com.redhat.ceylon.aether.apache.maven.model.resolution.UnresolvableModelException;
import com.redhat.ceylon.aether.apache.maven.repository.internal.ArtifactDescriptorUtils;
import com.redhat.ceylon.aether.eclipse.aether.RepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.RequestTrace;
import com.redhat.ceylon.aether.eclipse.aether.artifact.Artifact;
import com.redhat.ceylon.aether.eclipse.aether.artifact.DefaultArtifact;
import com.redhat.ceylon.aether.eclipse.aether.impl.ArtifactResolver;
import com.redhat.ceylon.aether.eclipse.aether.impl.RemoteRepositoryManager;
import com.redhat.ceylon.aether.eclipse.aether.impl.VersionRangeResolver;
import com.redhat.ceylon.aether.eclipse.aether.repository.RemoteRepository;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeRequest;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeResolutionException;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeResult;
import com.redhat.ceylon.aether.google.common.base.Predicate;
import com.redhat.ceylon.aether.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class DefaultModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context;
    private List<RemoteRepository> repositories;
    private final List<RemoteRepository> externalRepositories;
    private final ArtifactResolver resolver;
    private final VersionRangeResolver versionRangeResolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    public DefaultModelResolver(RepositorySystemSession session, RequestTrace trace, String context, ArtifactResolver resolver, VersionRangeResolver versionRangeResolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session;
        this.trace = trace;
        this.context = context;
        this.resolver = resolver;
        this.versionRangeResolver = versionRangeResolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        ArrayList<RemoteRepository> externalRepositories = new ArrayList<RemoteRepository>();
        externalRepositories.addAll(repositories);
        this.externalRepositories = Collections.unmodifiableList(externalRepositories);
        this.repositoryIds = new HashSet<String>();
    }

    private DefaultModelResolver(DefaultModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.context = original.context;
        this.resolver = original.resolver;
        this.versionRangeResolver = original.versionRangeResolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.externalRepositories = original.externalRepositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories()) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace) {
                return;
            }
            DefaultModelResolver.removeMatchingRepository(this.repositories, repository.getId());
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository(repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    private static void removeMatchingRepository(Iterable<RemoteRepository> repositories, final String id) {
        Iterables.removeIf(repositories, new Predicate<RemoteRepository>(){

            @Override
            public boolean apply(RemoteRepository remoteRepository) {
                return remoteRepository.getId().equals(id);
            }
        });
    }

    @Override
    public ModelResolver newCopy() {
        return new DefaultModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version2) throws UnresolvableModelException {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version2);
        try {
            ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, this.context);
            request.setTrace(this.trace);
            pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version2, e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        DefaultArtifact artifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "", "pom", parent.getVersion());
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, this.context);
        versionRangeRequest.setTrace(this.trace);
        try {
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException("No versions matched the requested range '" + parent.getVersion() + "'", parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException("The requested version range '" + parent.getVersion() + "' does not specify an upper bound", parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            parent.setVersion(versionRangeResult.getHighestVersion().toString());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), e);
        }
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }
}

