/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.repository.internal;

import com.redhat.ceylon.aether.apache.maven.repository.internal.LocalSnapshotMetadata;
import com.redhat.ceylon.aether.eclipse.aether.RepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.artifact.Artifact;
import com.redhat.ceylon.aether.eclipse.aether.impl.MetadataGenerator;
import com.redhat.ceylon.aether.eclipse.aether.installation.InstallRequest;
import com.redhat.ceylon.aether.eclipse.aether.metadata.Metadata;
import com.redhat.ceylon.aether.eclipse.aether.util.ConfigUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

class LocalSnapshotMetadataGenerator
implements MetadataGenerator {
    private Map<Object, LocalSnapshotMetadata> snapshots;
    private final boolean legacyFormat;

    public LocalSnapshotMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this.legacyFormat = ConfigUtils.getBoolean(session.getConfigProperties(), false, "maven.metadata.legacy");
        this.snapshots = new LinkedHashMap<Object, LocalSnapshotMetadata>();
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = LocalSnapshotMetadata.getKey(artifact);
            LocalSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new LocalSnapshotMetadata(artifact, this.legacyFormat);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return this.snapshots.values();
    }
}

