/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.apache.maven.settings.io;

import com.redhat.ceylon.aether.apache.commons.lang3.Validate;
import com.redhat.ceylon.aether.apache.maven.settings.Settings;
import com.redhat.ceylon.aether.apache.maven.settings.io.SettingsParseException;
import com.redhat.ceylon.aether.apache.maven.settings.io.SettingsReader;
import com.redhat.ceylon.aether.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import com.redhat.ceylon.aether.codehaus.plexus.component.annotations.Component;
import com.redhat.ceylon.aether.codehaus.plexus.util.IOUtil;
import com.redhat.ceylon.aether.codehaus.plexus.util.ReaderFactory;
import com.redhat.ceylon.aether.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

@Component(role=SettingsReader.class)
public class DefaultSettingsReader
implements SettingsReader {
    @Override
    public Settings read(File input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        Settings settings = this.read(ReaderFactory.newXmlReader(input), options);
        return settings;
    }

    @Override
    public Settings read(Reader input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings = r.read(input, this.isStrict(options));
            return settings;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    @Override
    public Settings read(InputStream input, Map<String, ?> options) throws IOException {
        Validate.notNull(input, "input cannot be null", new Object[0]);
        try {
            SettingsXpp3Reader r = new SettingsXpp3Reader();
            Settings settings = r.read(input, this.isStrict(options));
            return settings;
        }
        catch (XmlPullParserException e) {
            throw new SettingsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close(input);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("com.redhat.ceylon.aether.apache.maven.settings.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

