/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.internal.impl;

import com.redhat.ceylon.aether.eclipse.aether.RepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.spi.log.Logger;
import com.redhat.ceylon.aether.eclipse.aether.transfer.AbstractTransferListener;
import com.redhat.ceylon.aether.eclipse.aether.transfer.TransferCancelledException;
import com.redhat.ceylon.aether.eclipse.aether.transfer.TransferEvent;
import com.redhat.ceylon.aether.eclipse.aether.transfer.TransferListener;

class SafeTransferListener
extends AbstractTransferListener {
    private final Logger logger;
    private final TransferListener listener;

    public static TransferListener wrap(RepositorySystemSession session, Logger logger) {
        TransferListener listener = session.getTransferListener();
        if (listener == null) {
            return null;
        }
        return new SafeTransferListener(listener, logger);
    }

    protected SafeTransferListener(RepositorySystemSession session, Logger logger) {
        this(session.getTransferListener(), logger);
    }

    private SafeTransferListener(TransferListener listener, Logger logger) {
        this.listener = listener;
        this.logger = logger;
    }

    private void logError(TransferEvent event, Throwable e) {
        String msg = "Failed to dispatch transfer event '" + event + "' to " + this.listener.getClass().getCanonicalName();
        this.logger.debug(msg, e);
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferInitiated(event);
            }
            catch (RuntimeException e) {
                this.logError(event, e);
            }
            catch (LinkageError e) {
                this.logError(event, e);
            }
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferStarted(event);
            }
            catch (RuntimeException e) {
                this.logError(event, e);
            }
            catch (LinkageError e) {
                this.logError(event, e);
            }
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferProgressed(event);
            }
            catch (RuntimeException e) {
                this.logError(event, e);
            }
            catch (LinkageError e) {
                this.logError(event, e);
            }
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        if (this.listener != null) {
            try {
                this.listener.transferCorrupted(event);
            }
            catch (RuntimeException e) {
                this.logError(event, e);
            }
            catch (LinkageError e) {
                this.logError(event, e);
            }
        }
    }

    public void transferSucceeded(TransferEvent event) {
        if (this.listener != null) {
            try {
                this.listener.transferSucceeded(event);
            }
            catch (RuntimeException e) {
                this.logError(event, e);
            }
            catch (LinkageError e) {
                this.logError(event, e);
            }
        }
    }

    public void transferFailed(TransferEvent event) {
        if (this.listener != null) {
            try {
                this.listener.transferFailed(event);
            }
            catch (RuntimeException e) {
                this.logError(event, e);
            }
            catch (LinkageError e) {
                this.logError(event, e);
            }
        }
    }
}

