/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.internal.impl;

import com.redhat.ceylon.aether.eclipse.aether.RepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.artifact.Artifact;
import com.redhat.ceylon.aether.eclipse.aether.internal.impl.SimpleDigest;
import com.redhat.ceylon.aether.eclipse.aether.metadata.Metadata;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalArtifactRegistration;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalArtifactRequest;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalArtifactResult;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalMetadataRegistration;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalMetadataRequest;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalMetadataResult;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalRepository;
import com.redhat.ceylon.aether.eclipse.aether.repository.LocalRepositoryManager;
import com.redhat.ceylon.aether.eclipse.aether.repository.RemoteRepository;
import com.redhat.ceylon.aether.eclipse.aether.spi.log.Logger;
import java.io.File;
import java.util.TreeSet;

class SimpleLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepository repository;

    public SimpleLocalRepositoryManager(File basedir) {
        this(basedir, "simple");
    }

    public SimpleLocalRepositoryManager(String basedir) {
        this(basedir != null ? new File(basedir) : null, "simple");
    }

    SimpleLocalRepositoryManager(File basedir, String type) {
        if (basedir == null) {
            throw new IllegalArgumentException("base directory has not been specified");
        }
        this.repository = new LocalRepository(basedir.getAbsoluteFile(), type);
    }

    public SimpleLocalRepositoryManager setLogger(Logger logger) {
        return this;
    }

    public LocalRepository getRepository() {
        return this.repository;
    }

    String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        if (local) {
            path.append(artifact.getBaseVersion());
        } else {
            path.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    public String getPathForLocalArtifact(Artifact artifact) {
        return this.getPathForArtifact(artifact, true);
    }

    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getPathForArtifact(artifact, false);
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        return this.getPath(metadata, "local");
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getPath(metadata, this.getRepositoryKey(repository, context));
    }

    String getRepositoryKey(RemoteRepository repository, String context) {
        String key;
        if (repository.isRepositoryManager()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(repository.getId());
            buffer.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            SimpleDigest digest = new SimpleDigest();
            digest.update(context);
            for (String subKey : subKeys) {
                digest.update(subKey);
            }
            buffer.append(digest.digest());
            key = buffer.toString();
        } else {
            key = repository.getId();
        }
        return key;
    }

    private String getPath(Metadata metadata, String repositoryKey) {
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path.append(metadata.getVersion()).append('/');
                }
            }
        }
        path.append(this.insertRepositoryKey(metadata.getType(), repositoryKey));
        return path.toString();
    }

    private String insertRepositoryKey(String filename, String repositoryKey) {
        int idx = filename.indexOf(46);
        String result = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
        return result;
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForArtifact(request.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            result.setAvailable(true);
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = new LocalMetadataResult(request);
        Metadata metadata = request.getMetadata();
        String context = request.getContext();
        RemoteRepository remote = request.getRepository();
        String path = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        File file = new File(this.getRepository().getBasedir(), path);
        if (file.isFile()) {
            result.setFile(file);
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
    }
}

