/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.resolution;

import com.redhat.ceylon.aether.eclipse.aether.graph.DependencyCycle;
import com.redhat.ceylon.aether.eclipse.aether.graph.DependencyNode;
import com.redhat.ceylon.aether.eclipse.aether.resolution.ArtifactResult;
import com.redhat.ceylon.aether.eclipse.aether.resolution.DependencyRequest;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyResult {
    private final DependencyRequest request;
    private DependencyNode root;
    private List<DependencyCycle> cycles;
    private List<Exception> collectExceptions;
    private List<ArtifactResult> artifactResults;

    public DependencyResult(DependencyRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("dependency request has not been specified");
        }
        this.request = request;
        this.root = request.getRoot();
        this.cycles = Collections.emptyList();
        this.collectExceptions = Collections.emptyList();
        this.artifactResults = Collections.emptyList();
    }

    public DependencyRequest getRequest() {
        return this.request;
    }

    public DependencyNode getRoot() {
        return this.root;
    }

    public DependencyResult setRoot(DependencyNode root) {
        this.root = root;
        return this;
    }

    public List<DependencyCycle> getCycles() {
        return this.cycles;
    }

    public DependencyResult setCycles(List<DependencyCycle> cycles) {
        this.cycles = cycles == null ? Collections.emptyList() : cycles;
        return this;
    }

    public List<Exception> getCollectExceptions() {
        return this.collectExceptions;
    }

    public DependencyResult setCollectExceptions(List<Exception> exceptions) {
        this.collectExceptions = exceptions == null ? Collections.emptyList() : exceptions;
        return this;
    }

    public List<ArtifactResult> getArtifactResults() {
        return this.artifactResults;
    }

    public DependencyResult setArtifactResults(List<ArtifactResult> results) {
        this.artifactResults = results == null ? Collections.emptyList() : results;
        return this;
    }

    public String toString() {
        return String.valueOf(this.artifactResults);
    }
}

