/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.resolution;

import com.redhat.ceylon.aether.eclipse.aether.repository.ArtifactRepository;
import com.redhat.ceylon.aether.eclipse.aether.resolution.VersionRangeRequest;
import com.redhat.ceylon.aether.eclipse.aether.version.Version;
import com.redhat.ceylon.aether.eclipse.aether.version.VersionConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionRangeResult {
    private final VersionRangeRequest request;
    private List<Exception> exceptions;
    private List<Version> versions;
    private Map<Version, ArtifactRepository> repositories;
    private VersionConstraint versionConstraint;

    public VersionRangeResult(VersionRangeRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("version range request has not been specified");
        }
        this.request = request;
        this.exceptions = Collections.emptyList();
        this.versions = Collections.emptyList();
        this.repositories = Collections.emptyMap();
    }

    public VersionRangeRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public VersionRangeResult addException(Exception exception) {
        if (exception != null) {
            if (this.exceptions.isEmpty()) {
                this.exceptions = new ArrayList<Exception>();
            }
            this.exceptions.add(exception);
        }
        return this;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public VersionRangeResult addVersion(Version version2) {
        if (this.versions.isEmpty()) {
            this.versions = new ArrayList<Version>();
        }
        this.versions.add(version2);
        return this;
    }

    public VersionRangeResult setVersions(List<Version> versions) {
        this.versions = versions == null ? Collections.emptyList() : versions;
        return this;
    }

    public Version getLowestVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        return this.versions.get(0);
    }

    public Version getHighestVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        return this.versions.get(this.versions.size() - 1);
    }

    public ArtifactRepository getRepository(Version version2) {
        return this.repositories.get(version2);
    }

    public VersionRangeResult setRepository(Version version2, ArtifactRepository repository) {
        if (repository != null) {
            if (this.repositories.isEmpty()) {
                this.repositories = new HashMap<Version, ArtifactRepository>();
            }
            this.repositories.put(version2, repository);
        }
        return this;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public VersionRangeResult setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
        return this;
    }

    public String toString() {
        return String.valueOf(this.repositories);
    }
}

