/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport;

import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.TransportListener;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.TransportTask;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;

public final class PutTask
extends TransportTask {
    private File dataFile;
    private byte[] dataBytes = EMPTY;

    public PutTask(URI location) {
        this.setLocation(location);
    }

    public InputStream newInputStream() throws IOException {
        if (this.dataFile != null) {
            return new FileInputStream(this.dataFile);
        }
        return new ByteArrayInputStream(this.dataBytes);
    }

    public long getDataLength() {
        if (this.dataFile != null) {
            return this.dataFile.length();
        }
        return this.dataBytes.length;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public PutTask setDataFile(File dataFile) {
        this.dataFile = dataFile;
        this.dataBytes = EMPTY;
        return this;
    }

    public PutTask setDataBytes(byte[] bytes) {
        this.dataBytes = bytes != null ? bytes : EMPTY;
        this.dataFile = null;
        return this;
    }

    public PutTask setDataString(String str) {
        try {
            return this.setDataBytes(str != null ? str.getBytes("UTF-8") : null);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public PutTask setListener(TransportListener listener) {
        super.setListener(listener);
        return this;
    }

    public String toString() {
        return ">> " + this.getLocation();
    }
}

