/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.transport.file;

import com.redhat.ceylon.aether.eclipse.aether.repository.RemoteRepository;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.AbstractTransporter;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.GetTask;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.PeekTask;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.PutTask;
import com.redhat.ceylon.aether.eclipse.aether.spi.connector.transport.TransportTask;
import com.redhat.ceylon.aether.eclipse.aether.spi.log.Logger;
import com.redhat.ceylon.aether.eclipse.aether.transfer.NoTransporterException;
import com.redhat.ceylon.aether.eclipse.aether.transport.file.PathUtils;
import com.redhat.ceylon.aether.eclipse.aether.transport.file.ResourceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

final class FileTransporter
extends AbstractTransporter {
    private final Logger logger;
    private final File basedir;

    public FileTransporter(RemoteRepository repository, Logger logger) throws NoTransporterException {
        if (!"file".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.logger = logger;
        this.basedir = new File(PathUtils.basedir(repository.getUrl())).getAbsoluteFile();
    }

    File getBasedir() {
        return this.basedir;
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    protected void implPeek(PeekTask task) throws Exception {
        this.getFile(task, true);
    }

    protected void implGet(GetTask task) throws Exception {
        File file = this.getFile(task, true);
        this.utilGet(task, new FileInputStream(file), true, file.length(), false);
    }

    protected void implPut(PutTask task) throws Exception {
        File file = this.getFile(task, false);
        file.getParentFile().mkdirs();
        try {
            this.utilPut(task, new FileOutputStream(file), true);
        }
        catch (Exception e) {
            if (!file.delete() && file.exists()) {
                this.logger.debug("Could not delete partial file " + file);
            }
            throw e;
        }
    }

    private File getFile(TransportTask task, boolean required) throws Exception {
        String path = task.getLocation().getPath();
        if (path.contains("../")) {
            throw new IllegalArgumentException("Illegal resource path: " + path);
        }
        File file = new File(this.basedir, path);
        if (required && !file.exists()) {
            throw new ResourceNotFoundException("Could not locate " + file);
        }
        return file;
    }

    protected void implClose() {
    }
}

