/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.transport.http;

import com.redhat.ceylon.aether.apache.http.conn.ssl.SSLSocketFactory;
import com.redhat.ceylon.aether.apache.http.conn.ssl.X509HostnameVerifier;
import com.redhat.ceylon.aether.eclipse.aether.transport.http.SslConfig;
import com.redhat.ceylon.aether.eclipse.aether.transport.http.X509HostnameVerifierAdapter;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

final class SslSocketFactory
extends SSLSocketFactory {
    private final String[] cipherSuites;
    private final String[] protocols;

    public SslSocketFactory(SslConfig config) {
        this(SslSocketFactory.getSocketFactory(config.context), SslSocketFactory.getHostnameVerifier(config.verifier), config.cipherSuites, config.protocols);
    }

    private static javax.net.ssl.SSLSocketFactory getSocketFactory(SSLContext context) {
        return context != null ? context.getSocketFactory() : (javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault();
    }

    private static X509HostnameVerifier getHostnameVerifier(HostnameVerifier verifier) {
        return verifier != null ? X509HostnameVerifierAdapter.adapt(verifier) : SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    }

    private SslSocketFactory(javax.net.ssl.SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier, String[] cipherSuites, String[] protocols) {
        super(socketfactory, hostnameVerifier);
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
        super.prepareSocket(socket);
        if (this.cipherSuites != null) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null) {
            socket.setEnabledProtocols(this.protocols);
        }
    }
}

