/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChecksumUtils {
    private ChecksumUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File checksumFile) throws IOException {
        String checksum;
        block18: {
            checksum = "";
            FileInputStream fis = new FileInputStream(checksumFile);
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"), 512);
                try {
                    String line;
                    do {
                        if ((line = br.readLine()) != null) continue;
                        break block18;
                    } while ((line = line.trim()).length() <= 0);
                    checksum = line;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> calc(File dataFile, Collection<String> algos) throws IOException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, MessageDigest> digests = new LinkedHashMap<String, MessageDigest>();
        for (String algo : algos) {
            try {
                digests.put(algo, MessageDigest.getInstance(algo));
            }
            catch (NoSuchAlgorithmException e) {
                results.put(algo, e);
            }
        }
        FileInputStream fis = new FileInputStream(dataFile);
        try {
            int read;
            byte[] buffer = new byte[32768];
            block10: while ((read = fis.read(buffer)) >= 0) {
                Iterator i$ = digests.values().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block10;
                    MessageDigest digest = (MessageDigest)i$.next();
                    digest.update(buffer, 0, read);
                }
                break;
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {}
        }
        for (Map.Entry entry : digests.entrySet()) {
            byte[] bytes = ((MessageDigest)entry.getValue()).digest();
            results.put((String)entry.getKey(), ChecksumUtils.toHexString(bytes));
        }
        return results;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(b));
        }
        return buffer.toString();
    }
}

