/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.util.graph.transformer;

import com.redhat.ceylon.aether.eclipse.aether.RepositoryException;
import com.redhat.ceylon.aether.eclipse.aether.collection.DependencyGraphTransformationContext;
import com.redhat.ceylon.aether.eclipse.aether.collection.DependencyGraphTransformer;
import com.redhat.ceylon.aether.eclipse.aether.graph.Dependency;
import com.redhat.ceylon.aether.eclipse.aether.graph.DependencyNode;

public final class JavaDependencyContextRefiner
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        String scope;
        String ctx = node.getRequestContext();
        if ("project".equals(ctx) && (scope = this.getClasspathScope(node)) != null) {
            ctx = ctx + '/' + scope;
            node.setRequestContext(ctx);
        }
        for (DependencyNode child : node.getChildren()) {
            this.transformGraph(child, context);
        }
        return node;
    }

    private String getClasspathScope(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return null;
        }
        String scope = dependency.getScope();
        if ("compile".equals(scope) || "system".equals(scope) || "provided".equals(scope)) {
            return "compile";
        }
        if ("runtime".equals(scope)) {
            return "runtime";
        }
        if ("test".equals(scope)) {
            return "test";
        }
        return null;
    }
}

