/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.util.graph.version;

import com.redhat.ceylon.aether.eclipse.aether.RepositorySystemSession;
import com.redhat.ceylon.aether.eclipse.aether.artifact.Artifact;
import com.redhat.ceylon.aether.eclipse.aether.collection.DependencyCollectionContext;
import com.redhat.ceylon.aether.eclipse.aether.collection.VersionFilter;
import com.redhat.ceylon.aether.eclipse.aether.util.ConfigUtils;
import com.redhat.ceylon.aether.eclipse.aether.util.graph.version.SnapshotVersionFilter;

public final class ContextualSnapshotVersionFilter
implements VersionFilter {
    public static final String CONFIG_PROP_ENABLE = "aether.snapshotFilter";
    private final SnapshotVersionFilter filter = new SnapshotVersionFilter();

    private boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_ENABLE);
    }

    public void filterVersions(VersionFilter.VersionFilterContext context) {
        if (this.isEnabled(context.getSession())) {
            this.filter.filterVersions(context);
        }
    }

    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        if (!this.isEnabled(context.getSession())) {
            Artifact artifact = context.getArtifact();
            if (artifact == null) {
                return this;
            }
            if (artifact.isSnapshot()) {
                return null;
            }
        }
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

