/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.eclipse.aether.util.repository;

import com.redhat.ceylon.aether.eclipse.aether.repository.Proxy;
import com.redhat.ceylon.aether.eclipse.aether.repository.ProxySelector;
import com.redhat.ceylon.aether.eclipse.aether.repository.RemoteRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultProxySelector
implements ProxySelector {
    private List<ProxyDef> proxies = new ArrayList<ProxyDef>();

    public DefaultProxySelector add(Proxy proxy, String nonProxyHosts) {
        return this.add(proxy, NonProxyHosts.split(nonProxyHosts));
    }

    public DefaultProxySelector add(Proxy proxy, Collection<String> nonProxyHosts) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy not specified");
        }
        this.proxies.add(new ProxyDef(proxy, nonProxyHosts));
        return this;
    }

    @Override
    public Proxy getProxy(RemoteRepository repository) {
        ProxyDef proxy2;
        HashMap<String, ProxyDef> candidates = new HashMap<String, ProxyDef>();
        String host = repository.getHost();
        for (ProxyDef proxy2 : this.proxies) {
            String key;
            if (proxy2.nonProxyHosts.isNonProxyHost(host) || candidates.containsKey(key = proxy2.proxy.getType().toLowerCase(Locale.ENGLISH))) continue;
            candidates.put(key, proxy2);
        }
        String protocol = repository.getProtocol().toLowerCase(Locale.ENGLISH);
        if ("davs".equals(protocol)) {
            protocol = "https";
        } else if ("dav".equals(protocol)) {
            protocol = "http";
        } else if (protocol.startsWith("dav:")) {
            protocol = protocol.substring("dav:".length());
        }
        proxy2 = (ProxyDef)candidates.get(protocol);
        if (proxy2 == null && "https".equals(protocol)) {
            proxy2 = (ProxyDef)candidates.get("http");
        }
        return proxy2 != null ? proxy2.proxy : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProxyDef {
        final Proxy proxy;
        final NonProxyHosts nonProxyHosts;

        public ProxyDef(Proxy proxy, Collection<String> nonProxyHosts) {
            this.proxy = proxy;
            this.nonProxyHosts = new NonProxyHosts(nonProxyHosts);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NonProxyHosts {
        private final Pattern[] patterns;

        public NonProxyHosts(Collection<String> nonProxyHosts) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (nonProxyHosts != null) {
                for (String nonProxyHost : nonProxyHosts) {
                    if (nonProxyHost == null || nonProxyHost.length() <= 0) continue;
                    String pattern = nonProxyHost;
                    pattern = pattern.replace(".", "\\.").replace("*", ".*");
                    patterns.add(Pattern.compile(pattern, 2));
                }
            }
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
        }

        static List<String> split(String nonProxyHosts) {
            List<String> hosts = null;
            if (nonProxyHosts != null) {
                hosts = Arrays.asList(nonProxyHosts.trim().split("\\s*[|,]\\s*"));
            }
            return hosts;
        }

        boolean isNonProxyHost(String host) {
            if (host != null) {
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(host).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

