/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine;

import com.redhat.ceylon.aether.github.sardine.model.Principal;
import javax.xml.namespace.QName;

public class DavPrincipal {
    public static final String KEY_SELF = "self";
    public static final String KEY_UNAUTHENTICATED = "unauthenticated";
    public static final String KEY_AUTHENTICATED = "authenticated";
    public static final String KEY_ALL = "all";
    private final PrincipalType principalType;
    private final String value;
    private final QName property;
    private final String displayName;

    public DavPrincipal(PrincipalType principalType, String value, String name) {
        this(principalType, value, null, name);
    }

    protected DavPrincipal(PrincipalType principalType, String value, QName property, String name) {
        if (value != null && principalType == PrincipalType.PROPERTY) {
            throw new IllegalArgumentException("Principal type property can't have a string value");
        }
        if (property != null && principalType != PrincipalType.PROPERTY) {
            throw new IllegalArgumentException("Principal type " + principalType.name() + " property is not allowed to have a QName property");
        }
        this.principalType = principalType;
        this.value = value;
        this.property = property;
        this.displayName = name;
    }

    public DavPrincipal(PrincipalType principalType, QName property, String name) {
        this(principalType, null, property, name);
    }

    public DavPrincipal(Principal principal) {
        this.displayName = null;
        if (principal.getHref() != null) {
            this.principalType = PrincipalType.HREF;
            this.value = principal.getHref();
            this.property = null;
        } else if (principal.getProperty() != null) {
            this.principalType = PrincipalType.PROPERTY;
            this.value = null;
            this.property = new QName(principal.getProperty().getProperty().getNamespaceURI(), principal.getProperty().getProperty().getLocalName());
        } else if (principal.getAll() != null || principal.getAuthenticated() != null || principal.getUnauthenticated() != null || principal.getSelf() != null) {
            this.principalType = PrincipalType.KEY;
            this.property = null;
            this.value = principal.getAll() != null ? KEY_ALL : (principal.getAuthenticated() != null ? KEY_AUTHENTICATED : (principal.getUnauthenticated() != null ? KEY_UNAUTHENTICATED : KEY_SELF));
        } else {
            this.principalType = null;
            this.value = null;
            this.property = null;
        }
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public String getValue() {
        return this.value;
    }

    public QName getProperty() {
        return this.property;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "[principalType=" + (Object)((Object)this.principalType) + ", value=" + this.value + ", property=" + this.property + ", displayName=" + this.displayName + "]";
    }

    public static enum PrincipalType {
        HREF,
        KEY,
        PROPERTY;

    }
}

