/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine;

import com.redhat.ceylon.aether.github.sardine.model.Creationdate;
import com.redhat.ceylon.aether.github.sardine.model.Displayname;
import com.redhat.ceylon.aether.github.sardine.model.Getcontentlanguage;
import com.redhat.ceylon.aether.github.sardine.model.Getcontentlength;
import com.redhat.ceylon.aether.github.sardine.model.Getcontenttype;
import com.redhat.ceylon.aether.github.sardine.model.Getetag;
import com.redhat.ceylon.aether.github.sardine.model.Getlastmodified;
import com.redhat.ceylon.aether.github.sardine.model.Propstat;
import com.redhat.ceylon.aether.github.sardine.model.Resourcetype;
import com.redhat.ceylon.aether.github.sardine.model.Response;
import com.redhat.ceylon.aether.github.sardine.util.SardineUtil;
import com.redhat.ceylon.aether.slf4j.Logger;
import com.redhat.ceylon.aether.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class DavResource {
    private static Logger log = LoggerFactory.getLogger(DavResource.class);
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final long DEFAULT_CONTENT_LENGTH = -1L;
    public static final String HTTPD_UNIX_DIRECTORY_CONTENT_TYPE = "httpd/unix-directory";
    private static final String SEPARATOR = "/";
    private final URI href;
    private final Date creation;
    private final Date modified;
    private final String contentType;
    private final String etag;
    private final String displayName;
    private final String contentLanguage;
    private final Long contentLength;
    private final Map<QName, String> customProps;

    protected DavResource(String href, Date creation, Date modified, String contentType, Long contentLength, String etag, String displayName, String contentLanguage, Map<QName, String> customProps) throws URISyntaxException {
        this.href = new URI(href);
        this.creation = creation;
        this.modified = modified;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.etag = etag;
        this.displayName = displayName;
        this.contentLanguage = contentLanguage;
        this.customProps = customProps;
    }

    public DavResource(Response response) throws URISyntaxException {
        this.href = new URI(response.getHref().get(0));
        this.creation = SardineUtil.parseDate(this.getCreationDate(response));
        this.modified = SardineUtil.parseDate(this.getModifiedDate(response));
        this.contentType = this.getContentType(response);
        this.contentLength = this.getContentLength(response);
        this.etag = this.getEtag(response);
        this.displayName = this.getDisplayName(response);
        this.contentLanguage = this.getContentLanguage(response);
        this.customProps = this.getCustomProps(response);
    }

    private String getModifiedDate(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Getlastmodified glm;
            if (propstat.getProp() == null || (glm = propstat.getProp().getGetlastmodified()) == null || glm.getContent().size() != 1) continue;
            return glm.getContent().get(0);
        }
        return null;
    }

    private String getCreationDate(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Creationdate gcd;
            if (propstat.getProp() == null || (gcd = propstat.getProp().getCreationdate()) == null || gcd.getContent().size() != 1) continue;
            return gcd.getContent().get(0);
        }
        return null;
    }

    private String getContentType(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            if (propstat.getProp() == null) continue;
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && resourcetype.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontenttype gtt = propstat.getProp().getGetcontenttype();
            if (gtt == null || gtt.getContent().size() != 1) continue;
            return gtt.getContent().get(0);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private long getContentLength(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return -1L;
        }
        for (Propstat propstat : list) {
            Getcontentlength gcl;
            if (propstat.getProp() == null || (gcl = propstat.getProp().getGetcontentlength()) == null || gcl.getContent().size() != 1) continue;
            try {
                return Long.parseLong(gcl.getContent().get(0));
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Failed to parse content length %s", gcl.getContent().get(0)));
            }
        }
        return -1L;
    }

    private String getEtag(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Getetag e;
            if (propstat.getProp() == null || (e = propstat.getProp().getGetetag()) == null || e.getContent().size() != 1) continue;
            return e.getContent().get(0);
        }
        return null;
    }

    private String getContentLanguage(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            if (propstat.getProp() == null) continue;
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && resourcetype.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontentlanguage gtl = propstat.getProp().getGetcontentlanguage();
            if (gtl == null || gtl.getContent().size() != 1) continue;
            return gtl.getContent().get(0);
        }
        return null;
    }

    private String getDisplayName(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Displayname dn;
            if (propstat.getProp() == null || (dn = propstat.getProp().getDisplayname()) == null || dn.getContent().size() != 1) continue;
            return dn.getContent().get(0);
        }
        return null;
    }

    private Map<QName, String> getCustomProps(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        HashMap<QName, String> customPropsMap = new HashMap<QName, String>();
        for (Propstat propstat : list) {
            if (propstat.getProp() == null) continue;
            List<Element> props = propstat.getProp().getAny();
            for (Element element : props) {
                String namespace = element.getNamespaceURI();
                if (namespace == null) {
                    customPropsMap.put(new QName("DAV:", element.getLocalName(), "d"), element.getTextContent());
                    continue;
                }
                if (element.getPrefix() == null) {
                    customPropsMap.put(new QName(element.getNamespaceURI(), element.getLocalName()), element.getTextContent());
                    continue;
                }
                customPropsMap.put(new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix()), element.getTextContent());
            }
        }
        return customPropsMap;
    }

    public Date getCreation() {
        return this.creation;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDirectory() {
        return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE.equals(this.contentType);
    }

    public Map<String, String> getCustomProps() {
        HashMap<String, String> local = new HashMap<String, String>();
        Map<QName, String> properties = this.getCustomPropsNS();
        for (QName key : properties.keySet()) {
            local.put(key.getLocalPart(), properties.get(key));
        }
        return local;
    }

    public Map<QName, String> getCustomPropsNS() {
        return this.customProps;
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        String path = this.href.getPath();
        try {
            if (path.endsWith(SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            return path.substring(path.lastIndexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warn(String.format("Failed to parse name from path %s", path));
            return null;
        }
    }

    public String getPath() {
        return this.href.getPath();
    }

    public String toString() {
        return this.getPath();
    }
}

