/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine.ant;

import com.redhat.ceylon.aether.apache.tools.ant.BuildException;
import com.redhat.ceylon.aether.apache.tools.ant.Task;
import com.redhat.ceylon.aether.github.sardine.Sardine;
import com.redhat.ceylon.aether.github.sardine.SardineFactory;
import com.redhat.ceylon.aether.github.sardine.ant.Command;
import com.redhat.ceylon.aether.github.sardine.ant.command.Copy;
import com.redhat.ceylon.aether.github.sardine.ant.command.CreateDirectory;
import com.redhat.ceylon.aether.github.sardine.ant.command.Delete;
import com.redhat.ceylon.aether.github.sardine.ant.command.Exists;
import com.redhat.ceylon.aether.github.sardine.ant.command.Move;
import com.redhat.ceylon.aether.github.sardine.ant.command.Put;
import java.util.ArrayList;
import java.util.List;

public class SardineTask
extends Task {
    private List<Command> fCommands = new ArrayList<Command>();
    private boolean fFailOnError = false;
    private String fUsername = null;
    private String fPassword = null;
    private String fPreemptiveAuthenticationHost;
    private Sardine fSardine = null;

    public void addCopy(Copy copy) {
        this.addCommand(copy);
    }

    public void addCreateDirectory(CreateDirectory createDirectory) {
        this.addCommand(createDirectory);
    }

    public void addDelete(Delete delete) {
        this.addCommand(delete);
    }

    public void addExists(Exists exists) {
        this.addCommand(exists);
    }

    public void addMove(Move move) {
        this.addCommand(move);
    }

    public void addPut(Put put) {
        this.addCommand(put);
    }

    private void addCommand(Command command) {
        command.setTask(this);
        this.fCommands.add(command);
    }

    public void execute() throws BuildException {
        try {
            this.fSardine = SardineFactory.begin(this.fUsername, this.fPassword);
            if (this.fPreemptiveAuthenticationHost != null && !this.fPreemptiveAuthenticationHost.isEmpty()) {
                this.fSardine.enablePreemptiveAuthentication(this.fPreemptiveAuthenticationHost);
            }
            for (Command command : this.fCommands) {
                command.executeCommand();
            }
        }
        catch (Exception e) {
            throw new BuildException("failed: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setFailonerror(boolean failonerror) {
        this.fFailOnError = failonerror;
    }

    public boolean isFailonerror() {
        return this.fFailOnError;
    }

    public void setUsername(String username) {
        this.fUsername = username;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public void setPreemptiveAuthenticationHost(String host) {
        this.fPreemptiveAuthenticationHost = host;
    }

    public Sardine getSardine() {
        return this.fSardine;
    }
}

