/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine.ant.command;

import com.redhat.ceylon.aether.apache.tools.ant.types.FileSet;
import com.redhat.ceylon.aether.github.sardine.ant.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Put
extends Command {
    private String fUrlString;
    private URL fDest;
    private List<FileSet> fSrcFileSets = new ArrayList<FileSet>();
    private File fSrcFile = null;
    private String fContentType;

    @Override
    protected void execute() throws Exception {
        long fileCounter = 0L;
        if (this.fSrcFile != null) {
            this.process(this.fSrcFile, this.fDest, false);
            ++fileCounter;
        } else {
            String urlString = this.fDest.toString();
            urlString = urlString.endsWith("/") ? urlString : urlString + '/';
            URL baseUrl = new URL(urlString);
            HashSet<URL> alreadyCreated = new HashSet<URL>();
            File currentParentDir = null;
            Iterator<FileSet> setIterator = this.fSrcFileSets.iterator();
            while (setIterator.hasNext()) {
                FileSet fileSet = setIterator.next();
                File dir = fileSet.getDir(this.getProject());
                this.log("putting from " + dir + " to " + baseUrl);
                String[] files = fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles();
                for (int idx = 0; idx < files.length; ++idx) {
                    String fileName = files[idx].replace('\\', '/');
                    File parentDir = new File(fileName).getParentFile();
                    if (parentDir == null || !parentDir.equals(currentParentDir)) {
                        this.checkOrCreateDir(baseUrl, parentDir, alreadyCreated);
                        currentParentDir = parentDir;
                    }
                    File srcFile = new File(dir, fileName);
                    URL destUrl = new URL(baseUrl, fileName);
                    boolean expectContinue = setIterator.hasNext() || idx + 1 < files.length;
                    this.process(srcFile, destUrl, expectContinue);
                    ++fileCounter;
                }
            }
        }
        this.log("putting of " + fileCounter + " file(s) completed");
    }

    private void checkOrCreateDir(URL baseUrl, File dir, Set<URL> createdDirs) throws IOException {
        URL dirUrl;
        if (dir != null) {
            this.checkOrCreateDir(baseUrl, dir.getParentFile(), createdDirs);
        }
        URL uRL = dirUrl = dir == null ? baseUrl : new URL(baseUrl, dir.getPath().replace('\\', '/'));
        if (createdDirs.contains(dirUrl)) {
            return;
        }
        if (!this.getSardine().exists(dirUrl.toString())) {
            this.log("creating directory " + dirUrl, 3);
            this.getSardine().createDirectory(dirUrl.toString());
            createdDirs.add(dirUrl);
        }
    }

    private void process(File file, URL dest, boolean expectContinue) throws Exception {
        this.log("putting " + file + " to " + dest + " with expectContinue=" + expectContinue, 3);
        this.getSardine().put(dest.toString(), new FileInputStream(file), this.fContentType, expectContinue);
    }

    @Override
    protected void validateAttributes() throws Exception {
        if (this.fUrlString == null) {
            throw new NullPointerException("url must not be null");
        }
        this.fDest = new URL(this.fUrlString);
        if (this.fSrcFile == null && this.fSrcFileSets.size() == 0) {
            throw new NullPointerException("Need to define either the file attribute or add a fileset.");
        }
        if (this.fSrcFile != null && !this.fSrcFile.isFile()) {
            throw new Exception(this.fSrcFile + " is not a file");
        }
    }

    public void setUrl(String urlString) {
        this.fUrlString = urlString;
    }

    public void setFile(File file) {
        this.fSrcFile = file;
    }

    public void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    public void addConfiguredFileset(FileSet value) {
        this.fSrcFileSets.add(value);
    }
}

