/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine.impl;

import com.redhat.ceylon.aether.apache.http.HttpEntity;
import com.redhat.ceylon.aether.apache.http.HttpHost;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.auth.AuthScope;
import com.redhat.ceylon.aether.apache.http.auth.NTCredentials;
import com.redhat.ceylon.aether.apache.http.auth.UsernamePasswordCredentials;
import com.redhat.ceylon.aether.apache.http.client.CredentialsProvider;
import com.redhat.ceylon.aether.apache.http.client.HttpResponseException;
import com.redhat.ceylon.aether.apache.http.client.ResponseHandler;
import com.redhat.ceylon.aether.apache.http.client.config.RequestConfig;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpDelete;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpGet;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpHead;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpPut;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpRequestBase;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpUriRequest;
import com.redhat.ceylon.aether.apache.http.client.protocol.HttpClientContext;
import com.redhat.ceylon.aether.apache.http.client.protocol.RequestAcceptEncoding;
import com.redhat.ceylon.aether.apache.http.client.protocol.ResponseContentEncoding;
import com.redhat.ceylon.aether.apache.http.config.Registry;
import com.redhat.ceylon.aether.apache.http.config.RegistryBuilder;
import com.redhat.ceylon.aether.apache.http.conn.HttpClientConnectionManager;
import com.redhat.ceylon.aether.apache.http.conn.SchemePortResolver;
import com.redhat.ceylon.aether.apache.http.conn.routing.HttpRoutePlanner;
import com.redhat.ceylon.aether.apache.http.conn.socket.ConnectionSocketFactory;
import com.redhat.ceylon.aether.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.redhat.ceylon.aether.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.redhat.ceylon.aether.apache.http.entity.ByteArrayEntity;
import com.redhat.ceylon.aether.apache.http.entity.InputStreamEntity;
import com.redhat.ceylon.aether.apache.http.entity.StringEntity;
import com.redhat.ceylon.aether.apache.http.impl.auth.BasicScheme;
import com.redhat.ceylon.aether.apache.http.impl.client.BasicAuthCache;
import com.redhat.ceylon.aether.apache.http.impl.client.BasicCredentialsProvider;
import com.redhat.ceylon.aether.apache.http.impl.client.CloseableHttpClient;
import com.redhat.ceylon.aether.apache.http.impl.client.HttpClientBuilder;
import com.redhat.ceylon.aether.apache.http.impl.client.HttpClients;
import com.redhat.ceylon.aether.apache.http.impl.conn.DefaultSchemePortResolver;
import com.redhat.ceylon.aether.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.redhat.ceylon.aether.apache.http.impl.conn.SystemDefaultRoutePlanner;
import com.redhat.ceylon.aether.apache.http.protocol.HTTP;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import com.redhat.ceylon.aether.github.sardine.DavAce;
import com.redhat.ceylon.aether.github.sardine.DavAcl;
import com.redhat.ceylon.aether.github.sardine.DavPrincipal;
import com.redhat.ceylon.aether.github.sardine.DavQuota;
import com.redhat.ceylon.aether.github.sardine.DavResource;
import com.redhat.ceylon.aether.github.sardine.Sardine;
import com.redhat.ceylon.aether.github.sardine.Version;
import com.redhat.ceylon.aether.github.sardine.impl.SardineRedirectStrategy;
import com.redhat.ceylon.aether.github.sardine.impl.handler.ExistsResponseHandler;
import com.redhat.ceylon.aether.github.sardine.impl.handler.LockResponseHandler;
import com.redhat.ceylon.aether.github.sardine.impl.handler.MultiStatusResponseHandler;
import com.redhat.ceylon.aether.github.sardine.impl.handler.VoidResponseHandler;
import com.redhat.ceylon.aether.github.sardine.impl.io.ConsumingInputStream;
import com.redhat.ceylon.aether.github.sardine.impl.io.ContentLengthInputStream;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpAcl;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpCopy;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpLock;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpMkCol;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpMove;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpPropFind;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpPropPatch;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpUnlock;
import com.redhat.ceylon.aether.github.sardine.model.Ace;
import com.redhat.ceylon.aether.github.sardine.model.Acl;
import com.redhat.ceylon.aether.github.sardine.model.Allprop;
import com.redhat.ceylon.aether.github.sardine.model.Displayname;
import com.redhat.ceylon.aether.github.sardine.model.Exclusive;
import com.redhat.ceylon.aether.github.sardine.model.Group;
import com.redhat.ceylon.aether.github.sardine.model.Lockinfo;
import com.redhat.ceylon.aether.github.sardine.model.Lockscope;
import com.redhat.ceylon.aether.github.sardine.model.Locktype;
import com.redhat.ceylon.aether.github.sardine.model.Multistatus;
import com.redhat.ceylon.aether.github.sardine.model.ObjectFactory;
import com.redhat.ceylon.aether.github.sardine.model.Owner;
import com.redhat.ceylon.aether.github.sardine.model.PrincipalCollectionSet;
import com.redhat.ceylon.aether.github.sardine.model.PrincipalURL;
import com.redhat.ceylon.aether.github.sardine.model.Prop;
import com.redhat.ceylon.aether.github.sardine.model.Propertyupdate;
import com.redhat.ceylon.aether.github.sardine.model.Propfind;
import com.redhat.ceylon.aether.github.sardine.model.Propstat;
import com.redhat.ceylon.aether.github.sardine.model.QuotaAvailableBytes;
import com.redhat.ceylon.aether.github.sardine.model.QuotaUsedBytes;
import com.redhat.ceylon.aether.github.sardine.model.Remove;
import com.redhat.ceylon.aether.github.sardine.model.Resourcetype;
import com.redhat.ceylon.aether.github.sardine.model.Response;
import com.redhat.ceylon.aether.github.sardine.model.Write;
import com.redhat.ceylon.aether.github.sardine.util.SardineUtil;
import com.redhat.ceylon.aether.slf4j.Logger;
import com.redhat.ceylon.aether.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SardineImpl
implements Sardine {
    private static Logger log = LoggerFactory.getLogger(DavResource.class);
    private static final String UTF_8 = "UTF-8";
    private CloseableHttpClient client;
    private HttpClientBuilder builder;
    private HttpClientContext context = HttpClientContext.create();

    public SardineImpl() {
        this.builder = this.configure(null, null);
        this.client = this.builder.build();
    }

    public SardineImpl(String username, String password) {
        this.builder = this.configure(null, this.getCredentialsProvider(username, password, null, null));
        this.client = this.builder.build();
    }

    public SardineImpl(String username, String password, ProxySelector selector) {
        this.builder = this.configure(selector, this.getCredentialsProvider(username, password, null, null));
        this.client = this.builder.build();
    }

    public SardineImpl(HttpClientBuilder builder) {
        this.builder = builder;
        this.client = this.builder.build();
    }

    public SardineImpl(HttpClientBuilder builder, String username, String password) {
        this.builder = builder;
        this.setCredentials(username, password);
    }

    @Override
    public void setCredentials(String username, String password) {
        this.setCredentials(username, password, "", "");
    }

    @Override
    public void setCredentials(String username, String password, String domain, String workstation) {
        this.builder.setDefaultCredentialsProvider(this.getCredentialsProvider(username, password, domain, workstation));
        this.client = this.builder.build();
    }

    private CredentialsProvider getCredentialsProvider(String username, String password, String domain, String workstation) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (username != null) {
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), new NTCredentials(username, password, workstation, domain));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "negotiate"), new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Kerberos"), new UsernamePasswordCredentials(username, password));
        }
        return provider;
    }

    @Override
    public void enableCompression() {
        this.builder.addInterceptorLast(new RequestAcceptEncoding());
        this.builder.addInterceptorLast(new ResponseContentEncoding());
        this.client = this.builder.build();
    }

    @Override
    public void disableCompression() {
        this.builder.disableContentCompression();
        this.client = this.builder.build();
    }

    @Override
    public void enablePreemptiveAuthentication(String hostname) {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        for (String scheme : Arrays.asList("http", "https")) {
            cache.put(new HttpHost(hostname, -1, scheme), basicAuth);
        }
        this.context.setAttribute("http.auth.auth-cache", cache);
    }

    @Override
    public void disablePreemptiveAuthentication() {
        this.context.removeAttribute("http.auth.auth-cache");
    }

    @Override
    public List<DavResource> getResources(String url) throws IOException {
        return this.list(url);
    }

    @Override
    public List<DavResource> list(String url) throws IOException {
        return this.list(url, 1);
    }

    @Override
    public List<DavResource> list(String url, int depth) throws IOException {
        return this.list(url, depth, true);
    }

    @Override
    public List<DavResource> list(String url, int depth, boolean allProp) throws IOException {
        if (allProp) {
            Propfind body = new Propfind();
            body.setAllprop(new Allprop());
            return this.list(url, depth, body);
        }
        return this.list(url, depth, Collections.<QName>emptySet());
    }

    @Override
    public List<DavResource> list(String url, int depth, Set<QName> props) throws IOException {
        Propfind body = new Propfind();
        Prop prop = new Prop();
        ObjectFactory objectFactory = new ObjectFactory();
        prop.setGetcontentlength(objectFactory.createGetcontentlength());
        prop.setGetlastmodified(objectFactory.createGetlastmodified());
        prop.setCreationdate(objectFactory.createCreationdate());
        prop.setDisplayname(objectFactory.createDisplayname());
        prop.setGetcontenttype(objectFactory.createGetcontenttype());
        prop.setResourcetype(objectFactory.createResourcetype());
        prop.setGetetag(objectFactory.createGetetag());
        List<Element> any = prop.getAny();
        for (QName entry : props) {
            Element element = SardineUtil.createElement(entry);
            any.add(element);
        }
        body.setProp(prop);
        return this.list(url, depth, body);
    }

    protected List<DavResource> list(String url, int depth, Propfind body) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth(Integer.toString(depth));
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public void setCustomProps(String url, Map<String, String> set, List<String> remove) throws IOException {
        this.patch(url, SardineUtil.toQName(set), SardineUtil.toQName(remove));
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps) throws IOException {
        return this.patch(url, setProps, Collections.<QName>emptyList());
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps, List<QName> removeProps) throws IOException {
        Element element;
        HttpPropPatch entity = new HttpPropPatch(url);
        Propertyupdate body = new Propertyupdate();
        com.redhat.ceylon.aether.github.sardine.model.Set set = new com.redhat.ceylon.aether.github.sardine.model.Set();
        body.getRemoveOrSet().add(set);
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        for (Map.Entry<QName, String> entry : setProps.entrySet()) {
            element = SardineUtil.createElement(entry.getKey());
            element.setTextContent(entry.getValue());
            any.add(element);
        }
        set.setProp(prop);
        Remove remove = new Remove();
        body.getRemoveOrSet().add(remove);
        prop = new Prop();
        any = prop.getAny();
        for (QName qName : removeProps) {
            element = SardineUtil.createElement(qName);
            any.add(element);
        }
        remove.setProp(prop);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public String lock(String url) throws IOException {
        HttpLock entity = new HttpLock(url);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        return this.execute(entity, new LockResponseHandler());
    }

    @Override
    public String refreshLock(String url, String token, String file) throws IOException {
        HttpLock entity = new HttpLock(url);
        entity.setHeader("If", "<" + file + "> (<" + token + ">)");
        return this.execute(entity, new LockResponseHandler());
    }

    @Override
    public void unlock(String url, String token) throws IOException {
        HttpUnlock entity = new HttpUnlock(url, token);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        this.execute(entity, new VoidResponseHandler());
    }

    @Override
    public void setAcl(String url, List<DavAce> aces) throws IOException {
        HttpAcl entity = new HttpAcl(url);
        Acl body = new Acl();
        body.setAce(new ArrayList<Ace>());
        for (DavAce davAce : aces) {
            if (davAce.getInherited() != null || davAce.isProtected()) continue;
            Ace ace = davAce.toModel();
            body.getAce().add(ace);
        }
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        this.execute(entity, new VoidResponseHandler());
    }

    @Override
    public DavAcl getAcl(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setOwner(new Owner());
        prop.setGroup(new Group());
        prop.setAcl(new Acl());
        body.setProp(prop);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavAcl(responses.get(0));
    }

    @Override
    public DavQuota getQuota(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setQuotaAvailableBytes(new QuotaAvailableBytes());
        prop.setQuotaUsedBytes(new QuotaUsedBytes());
        body.setProp(prop);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavQuota(responses.get(0));
    }

    @Override
    public List<DavPrincipal> getPrincipals(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("1");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setDisplayname(new Displayname());
        prop.setResourcetype(new Resourcetype());
        prop.setPrincipalURL(new PrincipalURL());
        body.setProp(prop);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<DavPrincipal> collections = new ArrayList<DavPrincipal>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getResourcetype() == null || propstat.getProp().getResourcetype().getPrincipal() == null) continue;
                collections.add(new DavPrincipal(DavPrincipal.PrincipalType.HREF, r.getHref().get(0), propstat.getProp().getDisplayname().getContent().get(0)));
            }
        }
        return collections;
    }

    @Override
    public List<String> getPrincipalCollectionSet(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setPrincipalCollectionSet(new PrincipalCollectionSet());
        body.setProp(prop);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<String> collections = new ArrayList<String>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getPrincipalCollectionSet() == null || propstat.getProp().getPrincipalCollectionSet().getHref() == null) continue;
                collections.addAll(propstat.getProp().getPrincipalCollectionSet().getHref());
            }
        }
        return collections;
    }

    @Override
    public ContentLengthInputStream get(String url) throws IOException {
        return this.get(url, Collections.emptyMap());
    }

    @Override
    public ContentLengthInputStream get(String url, Map<String, String> headers) throws IOException {
        HttpGet get = new HttpGet(url);
        for (String header : headers.keySet()) {
            get.addHeader(header, headers.get(header));
        }
        HttpResponse response = this.execute(get);
        VoidResponseHandler handler = new VoidResponseHandler();
        try {
            handler.handleResponse(response);
            return new ConsumingInputStream(response);
        }
        catch (IOException ex) {
            get.abort();
            throw ex;
        }
    }

    @Override
    public void put(String url, byte[] data) throws IOException {
        this.put(url, data, null);
    }

    @Override
    public void put(String url, byte[] data, String contentType) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        this.put(url, (HttpEntity)entity, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream) throws IOException {
        this.put(url, dataStream, (String)null);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType) throws IOException {
        this.put(url, dataStream, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue) throws IOException {
        this.put(url, dataStream, contentType, expectContinue, -1L);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue, long contentLength) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, contentLength);
        this.put(url, (HttpEntity)entity, contentType, expectContinue);
    }

    @Override
    public void put(String url, InputStream dataStream, Map<String, String> headers) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put(url, entity, headers);
    }

    public void put(String url, HttpEntity entity, String contentType, boolean expectContinue) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (contentType != null) {
            headers.put("Content-Type", contentType);
        }
        if (expectContinue) {
            headers.put("Expect", "100-continue");
        }
        this.put(url, entity, headers);
    }

    public void put(String url, HttpEntity entity, Map<String, String> headers) throws IOException {
        this.put(url, entity, headers, new VoidResponseHandler());
    }

    public <T> T put(String url, HttpEntity entity, Map<String, String> headers, ResponseHandler<T> handler) throws IOException {
        HttpPut put = new HttpPut(url);
        put.setEntity(entity);
        for (String header : headers.keySet()) {
            put.addHeader(header, headers.get(header));
        }
        if (entity.getContentType() == null && !put.containsHeader("Content-Type")) {
            put.addHeader("Content-Type", HTTP.DEF_CONTENT_CHARSET.name());
        }
        try {
            return this.execute(put, handler);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 417) {
                put.removeHeaders("Expect");
                if (entity.isRepeatable()) {
                    return this.execute(put, handler);
                }
            }
            throw e;
        }
    }

    @Override
    public void delete(String url) throws IOException {
        HttpDelete delete = new HttpDelete(url);
        this.execute(delete, new VoidResponseHandler());
    }

    @Override
    public void move(String sourceUrl, String destinationUrl) throws IOException {
        HttpMove move = new HttpMove(sourceUrl, destinationUrl);
        this.execute(move, new VoidResponseHandler());
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl) throws IOException {
        HttpCopy copy = new HttpCopy(sourceUrl, destinationUrl);
        this.execute(copy, new VoidResponseHandler());
    }

    @Override
    public void createDirectory(String url) throws IOException {
        HttpMkCol mkcol = new HttpMkCol(url);
        this.execute(mkcol, new VoidResponseHandler());
    }

    @Override
    public boolean exists(String url) throws IOException {
        HttpHead head = new HttpHead(url);
        return this.execute(head, new ExistsResponseHandler());
    }

    protected <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        try {
            this.context.removeAttribute("http.protocol.redirect-locations");
            return this.client.execute(request, responseHandler, (HttpContext)this.context);
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        try {
            this.context.removeAttribute("http.protocol.redirect-locations");
            return this.client.execute((HttpUriRequest)request, this.context);
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.client.close();
    }

    protected HttpClientBuilder configure(ProxySelector selector, CredentialsProvider credentials) {
        Registry<ConnectionSocketFactory> schemeRegistry = this.createDefaultSchemeRegistry();
        HttpClientConnectionManager cm = this.createDefaultConnectionManager(schemeRegistry);
        String version2 = Version.getSpecification();
        if (version2 == null) {
            version2 = "UNAVAILABLE";
        }
        return HttpClients.custom().setUserAgent("Sardine/" + version2).setDefaultCredentialsProvider(credentials).setRedirectStrategy(this.createDefaultRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setExpectContinueEnabled(false).build()).setConnectionManager(cm).setRoutePlanner(this.createDefaultRoutePlanner(this.createDefaultSchemePortResolver(), selector));
    }

    protected DefaultSchemePortResolver createDefaultSchemePortResolver() {
        return new DefaultSchemePortResolver();
    }

    protected SardineRedirectStrategy createDefaultRedirectStrategy() {
        return new SardineRedirectStrategy();
    }

    protected Registry<ConnectionSocketFactory> createDefaultSchemeRegistry() {
        return RegistryBuilder.create().register("http", this.createDefaultSocketFactory()).register("https", this.createDefaultSecureSocketFactory()).build();
    }

    protected ConnectionSocketFactory createDefaultSocketFactory() {
        return PlainConnectionSocketFactory.getSocketFactory();
    }

    protected ConnectionSocketFactory createDefaultSecureSocketFactory() {
        return SSLConnectionSocketFactory.getSocketFactory();
    }

    protected HttpClientConnectionManager createDefaultConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
        return new PoolingHttpClientConnectionManager(schemeRegistry);
    }

    protected HttpRoutePlanner createDefaultRoutePlanner(SchemePortResolver resolver, ProxySelector selector) {
        return new SystemDefaultRoutePlanner(resolver, selector);
    }
}

