/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine.impl;

import com.redhat.ceylon.aether.apache.http.HttpEntityEnclosingRequest;
import com.redhat.ceylon.aether.apache.http.HttpRequest;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.ProtocolException;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.redhat.ceylon.aether.apache.http.client.methods.HttpUriRequest;
import com.redhat.ceylon.aether.apache.http.impl.client.DefaultRedirectStrategy;
import com.redhat.ceylon.aether.apache.http.protocol.HttpContext;
import com.redhat.ceylon.aether.github.sardine.impl.methods.HttpPropFind;

public class SardineRedirectStrategy
extends DefaultRedirectStrategy {
    @Override
    protected boolean isRedirectable(String method) {
        if (super.isRedirectable(method)) {
            return true;
        }
        return method.equalsIgnoreCase("PROPFIND");
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("PROPFIND")) {
            return this.copyEntity(new HttpPropFind(this.getLocationURI(request, response, context)), request);
        }
        return super.getRedirect(request, response, context);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

