/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine.impl.handler;

import com.redhat.ceylon.aether.apache.http.HttpEntity;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.StatusLine;
import com.redhat.ceylon.aether.github.sardine.impl.SardineException;
import com.redhat.ceylon.aether.github.sardine.impl.handler.ValidatingResponseHandler;
import com.redhat.ceylon.aether.github.sardine.model.Prop;
import com.redhat.ceylon.aether.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;

public class LockResponseHandler
extends ValidatingResponseHandler<String> {
    @Override
    public String handleResponse(HttpResponse response) throws IOException {
        super.validateResponse(response);
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        if (entity == null) {
            throw new SardineException("No entity found in response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        try {
            return this.getToken(entity.getContent());
        }
        catch (IOException e) {
            throw new SardineException(e.getMessage(), statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
    }

    protected String getToken(InputStream stream) throws IOException {
        Prop prop = (Prop)SardineUtil.unmarshal(stream);
        return prop.getLockdiscovery().getActivelock().iterator().next().getLocktoken().getHref().iterator().next();
    }
}

