/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.aether.github.sardine.impl.handler;

import com.redhat.ceylon.aether.apache.http.HttpEntity;
import com.redhat.ceylon.aether.apache.http.HttpResponse;
import com.redhat.ceylon.aether.apache.http.StatusLine;
import com.redhat.ceylon.aether.github.sardine.impl.SardineException;
import com.redhat.ceylon.aether.github.sardine.impl.handler.ValidatingResponseHandler;
import com.redhat.ceylon.aether.github.sardine.model.Multistatus;
import com.redhat.ceylon.aether.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;

public class MultiStatusResponseHandler
extends ValidatingResponseHandler<Multistatus> {
    @Override
    public Multistatus handleResponse(HttpResponse response) throws IOException {
        super.validateResponse(response);
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        if (entity == null) {
            throw new SardineException("No entity found in response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        try {
            return this.getMultistatus(entity.getContent());
        }
        catch (IOException e) {
            throw new SardineException(e.getMessage(), statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
    }

    protected Multistatus getMultistatus(InputStream stream) throws IOException {
        return (Multistatus)SardineUtil.unmarshal(stream);
    }
}

