/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDoc;
import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndexApiDoc
extends CeylonDoc {
    private final Module module;

    public IndexApiDoc(CeylonDocTool tool, Writer writer, Module module) throws IOException {
        super(module, tool, writer);
        this.module = module;
    }

    public void generate() throws IOException {
        List<Declaration> declarations = this.collectDeclarations();
        this.writeHeader("Index", new String[0]);
        this.writeNavBar();
        this.open("div class='container-fluid'");
        this.write("<h1>Index</h1>");
        this.writeIndexTable(declarations);
        this.close("div");
        this.writeFooter(new String[0]);
    }

    private void writeIndexTable(List<Declaration> declarations) throws IOException {
        this.open("table id='api-index' class='table table-hover'");
        this.open("tbody");
        for (Declaration declaration : declarations) {
            this.writeIndexRow(declaration);
        }
        this.close("tbody");
        this.close("table");
    }

    private void writeIndexRow(Declaration declaration) throws IOException {
        this.open("tr");
        this.open("td id='" + declaration.getQualifiedNameString() + "'");
        this.writeIcon(declaration);
        this.open("code");
        this.linkRenderer().to(declaration).printAbbreviated(false).printTypeParameters(false).write();
        this.close("code");
        this.close("td");
        this.open("td");
        this.write(Util.getDocFirstLine(declaration, this.linkRenderer()));
        this.writeTagged(declaration);
        this.close("td");
        this.close("tr");
    }

    private List<Declaration> collectDeclarations() {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        for (Package pkg : this.tool.getPackages(this.module)) {
            if (!this.tool.shouldInclude(pkg)) continue;
            List<Declaration> members = pkg.getMembers();
            for (Declaration member : members) {
                if (!this.tool.shouldInclude(member) || member instanceof Value && ((Value)member).getTypeDeclaration().isAnonymous()) continue;
                declarations.add(member);
            }
        }
        Collections.sort(declarations, Util.ReferenceableComparatorByName.INSTANCE);
        return declarations;
    }

    @Override
    protected void writeNavBarExpandAllCollapseAll() throws IOException {
    }

    @Override
    protected void writeNavBarIndexMenu() throws IOException {
    }

    @Override
    protected Object getFromObject() {
        return this.module;
    }
}

