/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDoc;
import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.CeylondMessages;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class IndexDoc
extends CeylonDoc {
    private Module module;
    private Set<String> tagIndex = new TreeSet<String>();

    public IndexDoc(CeylonDocTool tool, Writer writer, Module module) throws IOException {
        super(module, tool, writer);
        this.module = module;
    }

    public void generate() throws IOException {
        this.write("var index = [\n");
        this.indexPackages();
        this.write("];\n");
        this.writeTagIndex();
    }

    private void writeTagIndex() throws IOException {
        this.write("var tagIndex = [\n");
        Iterator<String> tagIterator = this.tagIndex.iterator();
        while (tagIterator.hasNext()) {
            this.write("'");
            this.write(this.escapeJSONString(tagIterator.next()));
            this.write("'");
            if (!tagIterator.hasNext()) continue;
            this.write(",\n");
        }
        this.write("];\n");
    }

    private void indexPackages() throws IOException {
        for (Package pkg : this.tool.getPackages(this.module)) {
            this.indexPackage(pkg);
        }
        this.writeIndexElement(this.module.getNameAsString(), this.getType(this.module), this.linkRenderer().to(this.module).getUrl(), Util.getDocFirstLine(this.module, this.linkRenderer()), Util.getTags(this.module), this.getIcons(this.module), null);
    }

    private void indexPackage(Package pkg) throws IOException {
        this.writeIndexElement(pkg.getNameAsString(), this.getType(pkg), this.linkRenderer().to(pkg).getUrl(), Util.getDocFirstLine(pkg, this.linkRenderer()), Util.getTags(pkg), this.getIcons(pkg), null);
        this.write(",\n");
        this.indexMembers(pkg, pkg.getMembers());
        List<String> tags = Util.getTags(pkg);
        this.tagIndex.addAll(tags);
    }

    private void indexMembers(Scope container, List<Declaration> members) throws IOException {
        for (Declaration decl : members) {
            if (!this.tool.shouldInclude(decl)) continue;
            if (decl instanceof ClassOrInterface) {
                ClassOrInterface classOrInterface = (ClassOrInterface)decl;
                this.indexMembers(classOrInterface, classOrInterface.getMembers());
            }
            if (!this.indexDecl(container, decl)) continue;
            this.write(",\n");
        }
    }

    private boolean indexDecl(Scope container, Declaration decl) throws IOException {
        String url;
        String name = Util.getDeclarationName(decl);
        String qualifier = "";
        if (decl instanceof ClassOrInterface) {
            url = this.linkRenderer().to(decl).getUrl();
        } else if (decl instanceof FunctionOrValue && !(decl instanceof Setter) && !((FunctionOrValue)decl).isParameter() || decl instanceof TypeAlias || decl instanceof Constructor) {
            url = this.tool.getObjectUrl(this.module, container, false) + "#" + name;
            if (decl.isMember()) {
                qualifier = ((ClassOrInterface)container).getName() + ".";
                name = qualifier + name;
            }
        } else {
            if (decl instanceof Setter || decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter() || decl instanceof TypeParameter) {
                return false;
            }
            throw new RuntimeException("Unknown type of object: " + decl);
        }
        String type = this.getType(decl);
        String doc = Util.getDocFirstLine(decl, this.linkRenderer());
        List<String> tags = Util.getTags(decl);
        this.tagIndex.addAll(tags);
        this.writeIndexElement(name, type, url, doc, tags, this.getIcons(decl), null);
        for (String alias : decl.getAliases()) {
            this.write(",\n");
            this.writeIndexElement(qualifier + alias, type, url, doc, tags, this.getIcons(decl), name);
        }
        return true;
    }

    private void writeIndexElement(String name, String type, String url, String doc, List<String> tags, List<String> icons, String aliasFor) throws IOException {
        this.write("{'name': '");
        this.write(name);
        this.write("', 'type': '");
        this.write(type);
        this.write("', 'url': '");
        this.write(url);
        this.write("', 'doc': '");
        this.write(this.escapeJSONString(doc).trim());
        this.write("', 'tags': [");
        if (tags != null) {
            Iterator<String> tagIterator = tags.iterator();
            while (tagIterator.hasNext()) {
                this.write("'");
                this.write(this.escapeJSONString(tagIterator.next()).trim());
                this.write("'");
                if (!tagIterator.hasNext()) continue;
                this.write(", ");
            }
        }
        this.write("],");
        this.write("'icons': [");
        if (icons != null) {
            Iterator<String> iconIterator = icons.iterator();
            while (iconIterator.hasNext()) {
                this.write("'");
                this.write(this.escapeJSONString(iconIterator.next()).trim());
                this.write("'");
                if (!iconIterator.hasNext()) continue;
                this.write(", ");
            }
        }
        this.write("]");
        if (aliasFor != null) {
            this.write(", 'aliasFor': '");
            this.write(aliasFor);
            this.write("'");
        }
        this.write("}");
    }

    private String escapeJSONString(String doc) {
        if (doc == null) {
            return "";
        }
        char[] chars = doc.toCharArray();
        StringBuffer escaped = new StringBuffer(chars.length * 2);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n') {
                escaped.append("\\n");
                continue;
            }
            if (c == '\'') {
                escaped.append("\\'");
                continue;
            }
            if (c == '\\') {
                escaped.append("\\\\");
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private String getType(Object obj) {
        if (obj instanceof Class) {
            return !((Class)obj).isAnonymous() ? "class" : "object";
        }
        if (obj instanceof Interface) {
            return "interface";
        }
        if (obj instanceof TypeAlias) {
            return "alias";
        }
        if (obj instanceof Tree.AttributeDeclaration || obj instanceof Declaration && Decl.isGetter((Declaration)obj)) {
            return "attribute";
        }
        if (obj instanceof Function) {
            return "function";
        }
        if (obj instanceof Value) {
            return "value";
        }
        if (obj instanceof Package) {
            return "package";
        }
        if (obj instanceof Module) {
            return "module";
        }
        if (obj instanceof Constructor) {
            return "constructor";
        }
        throw new RuntimeException(CeylondMessages.msg("error.unexpected", obj));
    }

    @Override
    protected Object getFromObject() {
        return this.module;
    }
}

