/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDoc;
import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.PackageDoc;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;

public class ModuleDoc
extends CeylonDoc {
    private Module module;
    private PackageDoc rootPackageDoc;

    public ModuleDoc(CeylonDocTool tool, Writer writer, Module module) throws IOException {
        super(module, tool, writer);
        this.module = module;
    }

    public void generate() throws IOException {
        this.writeHeader("Overview", new String[0]);
        this.writeNavBar();
        this.open("div class='container-fluid'");
        this.writeDescription();
        this.writePackagesTable("Packages", this.tool.getPackages(this.module));
        this.writeDependencies();
        this.close("div");
        for (Package pkg : this.module.getPackages()) {
            if (!this.tool.isRootPackage(this.module, pkg) || pkg.getMembers().isEmpty()) continue;
            this.rootPackageDoc = new PackageDoc(this.tool, this.writer, pkg);
            this.rootPackageDoc.generate();
        }
        this.writeFooter(new String[0]);
    }

    @Override
    protected void registerAdditionalKeyboardShortcuts() throws IOException {
        if (this.rootPackageDoc != null) {
            this.rootPackageDoc.registerAdditionalKeyboardShortcuts();
            this.keyboardShortcuts.putAll(this.rootPackageDoc.keyboardShortcuts);
        }
    }

    private void writeDescription() throws IOException {
        this.open("div class='module-description'");
        this.writeLinkSourceCode(this.module);
        String doc = Util.getDoc(this.module, this.linkRenderer());
        if (Util.isEmpty(doc)) {
            this.tool.warningMissingDoc(this.module.getNameAsString(), this.module);
        }
        this.around("div class='doc section'", doc);
        this.writeAnnotations(this.module);
        this.writePlatform(this.module);
        this.writeBy(this.module);
        this.writeSee(this.module);
        this.writeSince(this.module);
        this.writeLicense(this.module);
        this.close("div");
    }

    private void writePlatform(Module module) throws IOException {
        if (module.isNative()) {
            ArrayList<String> backendNames = new ArrayList<String>();
            for (Backend backend : module.getNativeBackends()) {
                backendNames.add(backend.name);
            }
            this.open("div class='platform section'");
            this.around("span class='title'", "Platform: ");
            this.around("span class='value'", Util.join(", ", backendNames));
            this.close("div");
        }
    }

    private void writeLicense(Module module) throws IOException {
        Annotation annotation = Util.getAnnotation(module.getUnit(), module.getAnnotations(), "license");
        if (annotation == null) {
            return;
        }
        String license = annotation.getPositionalArguments().get(0);
        if (license == null || license.isEmpty()) {
            return;
        }
        this.open("div class='license section'");
        this.around("span class='title'", "License: ");
        this.around("span class='value'", license);
        this.close("div");
    }

    private void writeDependencies() throws IOException {
        ArrayList<ModuleImport> moduleImports = new ArrayList<ModuleImport>(this.module.getImports());
        ListIterator moduleImportIterator = moduleImports.listIterator();
        while (moduleImportIterator.hasNext()) {
            ModuleImport moduleImport = (ModuleImport)moduleImportIterator.next();
            if (!moduleImport.getModule().getNameAsString().equals("ceylon.language")) continue;
            moduleImportIterator.remove();
        }
        Collections.sort(moduleImports, Util.ModuleImportComparatorByName.INSTANCE);
        if (!moduleImports.isEmpty()) {
            this.openTable("section-dependencies", "Dependencies", 3, false);
            for (ModuleImport moduleImport : moduleImports) {
                this.writeDependencyRow(moduleImport);
            }
            this.closeTable();
        }
    }

    private void writeDependencyRow(ModuleImport moduleImport) throws IOException {
        StringBuilder tooltip = new StringBuilder();
        if (moduleImport.isExport()) {
            tooltip.append("shared ");
        }
        if (moduleImport.isOptional()) {
            tooltip.append("optional ");
        }
        tooltip.append("import of module ");
        tooltip.append(moduleImport.getModule().getNameAsString());
        tooltip.append(" ");
        tooltip.append(moduleImport.getModule().getVersion());
        this.open("tr");
        this.open("td class='shrink'");
        this.open("span title='" + tooltip + "'");
        this.writeIcon(moduleImport);
        this.close("span");
        this.open("code class='decl-label'");
        this.linkRenderer().to(moduleImport.getModule()).write();
        Backends backends = moduleImport.getNativeBackends();
        if (!backends.none()) {
            this.write(" (");
            this.write(backends.names());
            this.write(")");
        }
        this.close("code");
        this.close("td");
        this.open("td class='shrink'");
        this.open("code");
        this.write(moduleImport.getModule().getVersion());
        this.close("code");
        this.close("td");
        this.open("td");
        this.open("div class='description import-description'");
        this.write(Util.getDoc(moduleImport, this.linkRenderer()));
        this.close("div");
        this.close("td");
        this.close("tr");
    }

    @Override
    protected Object getFromObject() {
        return this.module;
    }
}

