/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class FilterRule {
    protected Boolean include;

    FilterRule(boolean include) {
        this.include = include ? Boolean.TRUE : Boolean.FALSE;
    }

    abstract Boolean accept(String var1);

    static class MatchFilterRule
    extends FilterRule {
        private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");
        private final Pattern pattern;

        MatchFilterRule(String glob, boolean include) {
            super(include);
            this.pattern = MatchFilterRule.getGlobPattern(glob);
        }

        private static Pattern getGlobPattern(String glob) {
            StringBuilder patternBuilder = new StringBuilder();
            Matcher m = GLOB_PATTERN.matcher(glob);
            boolean lastWasSlash = false;
            while (m.find()) {
                lastWasSlash = false;
                String grp = m.group(1);
                if (grp != null) {
                    if (grp.length() == 2) {
                        patternBuilder.append(".*");
                        continue;
                    }
                    patternBuilder.append("[^/]*");
                    continue;
                }
                grp = m.group(2);
                if (grp != null) {
                    patternBuilder.append("[^/]");
                    continue;
                }
                grp = m.group(3);
                if (grp != null) {
                    patternBuilder.append(Pattern.quote(m.group().substring(1)));
                    continue;
                }
                grp = m.group(4);
                if (grp != null) {
                    patternBuilder.append("/+");
                    lastWasSlash = true;
                    continue;
                }
                patternBuilder.append(Pattern.quote(m.group()));
            }
            if (lastWasSlash) {
                patternBuilder.append(".*");
            } else {
                patternBuilder.append("(?:/.*)?");
            }
            return Pattern.compile(patternBuilder.toString());
        }

        @Override
        Boolean accept(String path) {
            return this.pattern.matcher(path).matches() ? this.include : null;
        }
    }

    static class IsFilterRule
    extends FilterRule {
        private String path;

        IsFilterRule(String path, boolean include) {
            super(include);
            this.path = path;
        }

        @Override
        Boolean accept(String path) {
            return this.path.equals(path) ? this.include : null;
        }
    }

    static class IsChildOfFilterRule
    extends FilterRule {
        private final String prefix;

        IsChildOfFilterRule(String path, boolean include) {
            super(include);
            this.prefix = path.charAt(path.length() - 1) == '/' ? path : path + "/";
        }

        @Override
        Boolean accept(String path) {
            return path.startsWith(this.prefix) ? this.include : null;
        }
    }

    static class SetFilterRule
    extends FilterRule {
        private final Set<String> paths;

        SetFilterRule(Set<String> paths, boolean include) {
            super(include);
            this.paths = paths;
        }

        @Override
        Boolean accept(String path) {
            return this.paths.contains(path) ? this.include : null;
        }
    }
}

