/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import java.util.Objects;

public class MavenArtifactContext
extends ArtifactContext {
    private static final long serialVersionUID = -7584989942190722636L;
    private String classifier;
    private String packaging;
    public static final String NAMESPACE = "maven";

    private static String moduleName(String groupId, String artifactId, String classifier) {
        return classifier == null || classifier.isEmpty() ? groupId + ":" + artifactId : groupId + ":" + artifactId + ":" + classifier;
    }

    public MavenArtifactContext(String groupId, String artifactId, String classifier, String version2, String packaging) {
        super(NAMESPACE, MavenArtifactContext.moduleName(groupId, artifactId, classifier), version2);
        this.classifier = classifier;
        this.packaging = packaging;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MavenArtifactContext)) {
                return this.classifier == null && this.packaging == null;
            }
            MavenArtifactContext other = (MavenArtifactContext)obj;
            return Objects.equals(this.classifier, other.classifier) && Objects.equals(this.packaging, other.packaging);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.classifier == null && this.packaging == null) {
            return hash;
        }
        hash = 37 * hash + (this.classifier != null ? this.classifier.hashCode() : 0);
        hash = 37 * hash + (this.packaging != null ? this.packaging.hashCode() : 0);
        return hash;
    }
}

