/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ModuleScope;

public final class ModuleDependencyInfo
implements Comparable<ModuleDependencyInfo> {
    private String namespace;
    private String name;
    private String version;
    private boolean optional;
    private boolean shared;
    private ModuleScope scope;
    private Backends backends;

    public ModuleDependencyInfo(String namespace, String name, String version2, boolean optional, boolean shared) {
        this(namespace, name, version2, optional, shared, Backends.ANY);
    }

    public ModuleDependencyInfo(String namespace, String name, String version2, boolean optional, boolean shared, Backends backends) {
        this(namespace, name, version2, optional, shared, backends, ModuleScope.COMPILE);
    }

    public ModuleDependencyInfo(String namespace, String name, String version2, boolean optional, boolean shared, Backends backends, ModuleScope scope) {
        this.namespace = namespace;
        this.name = name;
        this.version = version2;
        this.optional = optional;
        this.shared = shared;
        this.scope = scope;
        Backends backends2 = this.backends = backends != null ? backends : Backends.ANY;
        assert (ModuleUtil.validNamespace(namespace));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExport() {
        return this.shared;
    }

    public ModuleScope getModuleScope() {
        return this.scope;
    }

    public Backends getNativeBackends() {
        return this.backends;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependencyInfo that = (ModuleDependencyInfo)o;
        return that.name.equals(this.name) && that.version.equals(this.version) && that.shared == this.shared && that.scope == this.scope && that.optional == this.optional;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(ModuleDependencyInfo that) {
        int res = this.name.compareTo(that.name);
        if (res == 0 && (res = this.version.compareTo(that.version)) == 0 && (res = Boolean.compare(this.shared, that.shared)) == 0 && (res = Boolean.compare(this.optional, that.optional)) == 0) {
            res = this.scope.compareTo(that.scope);
        }
        return res;
    }

    public String toString() {
        return (this.shared ? "shared " : "") + (this.optional ? "optional " : "") + (this.namespace != null ? this.namespace + ":" : "") + this.getModuleName() + (this.scope != ModuleScope.COMPILE ? " " + (Object)((Object)this.scope) : "");
    }

    public String getModuleName() {
        return this.name + "/" + this.version;
    }
}

