/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ModuleSearchResult {
    private NavigableMap<String, ModuleDetails> results = new TreeMap<String, ModuleDetails>();
    private long[] nextPagingInfo;
    private long start;
    private boolean hasMoreResults;

    public void addResult(String moduleName, ModuleDetails otherDetails) {
        ModuleDetails details;
        if (this.results.containsKey(moduleName)) {
            details = (ModuleDetails)this.results.get(moduleName);
        } else {
            details = new ModuleDetails(otherDetails.namespace, moduleName);
            this.results.put(moduleName, details);
        }
        details.getVersions().addAll(otherDetails.getVersions());
    }

    public void addResult(String moduleName, ModuleVersionDetails mvd) {
        ModuleDetails details;
        if (this.results.containsKey(moduleName)) {
            details = (ModuleDetails)this.results.get(moduleName);
        } else {
            details = new ModuleDetails(mvd.getNamespace(), moduleName);
            this.results.put(moduleName, details);
        }
        details.getVersions().add(mvd);
    }

    public Collection<ModuleDetails> getResults() {
        return this.results.values();
    }

    public NavigableSet<String> getModuleNames() {
        return this.results.navigableKeySet();
    }

    public ModuleDetails getResult(String module) {
        return (ModuleDetails)this.results.get(module);
    }

    public long[] getNextPagingInfo() {
        return this.nextPagingInfo;
    }

    public void setNextPagingInfo(long[] nextPagingInfo) {
        this.nextPagingInfo = nextPagingInfo;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public boolean getHasMoreResults() {
        return this.hasMoreResults;
    }

    public void setHasMoreResults(boolean hasMoreResults) {
        this.hasMoreResults = hasMoreResults;
    }

    public long getCount() {
        return this.results.size();
    }

    public static class ModuleDetails
    implements Comparable<ModuleDetails> {
        private final String namespace;
        private final String name;
        private NavigableSet<ModuleVersionDetails> versions = new TreeSet<ModuleVersionDetails>();

        public ModuleDetails(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public ModuleDetails(String namespace, String name, String doc, String license, SortedSet<String> authors, SortedSet<String> versions, SortedSet<ModuleDependencyInfo> dependencies, SortedSet<ModuleVersionArtifact> artifacts, boolean remote, String origin) {
            this.namespace = namespace;
            this.name = name;
            for (String v : versions) {
                ModuleVersionDetails mvd = new ModuleVersionDetails(namespace, name, v, null, null);
                mvd.setDoc(doc);
                mvd.setLicense(license);
                mvd.getAuthors().addAll(authors);
                mvd.getDependencies().addAll(dependencies);
                mvd.getArtifactTypes().addAll(artifacts);
                mvd.setRemote(remote);
                mvd.setOrigin(origin);
                this.versions.add(mvd);
            }
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public NavigableSet<ModuleVersionDetails> getVersions() {
            return this.versions;
        }

        public ModuleVersionDetails getLastVersion() {
            if (this.versions.isEmpty()) {
                return null;
            }
            return (ModuleVersionDetails)this.versions.last();
        }

        public String getLicense() {
            return this.getLastVersion() != null ? this.getLastVersion().getLicense() : null;
        }

        public String getDoc() {
            return this.getLastVersion() != null ? this.getLastVersion().getDoc() : null;
        }

        public boolean isRemote() {
            return this.getLastVersion() != null ? this.getLastVersion().isRemote() : false;
        }

        public String getOrigin() {
            return this.getLastVersion() != null ? this.getLastVersion().getOrigin() : null;
        }

        public NavigableSet<String> getAuthors() {
            return this.getLastVersion() != null ? this.getLastVersion().getAuthors() : null;
        }

        public NavigableSet<ModuleDependencyInfo> getDependencies() {
            return this.getLastVersion() != null ? this.getLastVersion().getDependencies() : null;
        }

        public NavigableSet<ModuleVersionArtifact> getArtifactTypes() {
            return this.getLastVersion() != null ? this.getLastVersion().getArtifactTypes() : null;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModuleDetails) {
                return this.name.equals(((ModuleDetails)obj).name);
            }
            return false;
        }

        @Override
        public int compareTo(ModuleDetails o) {
            int res = this.name.compareTo(o.name);
            if (res == 0) {
                return this.getLastVersion().compareTo(o.getLastVersion());
            }
            return res;
        }

        public String toString() {
            return "ModuleSearchResult [name: " + this.name + ", license: " + this.getLicense() + ", doc: " + this.getDoc() + ", authors: " + this.getAuthors() + ", versions: " + this.getVersions() + ", deps: " + this.getDependencies() + ", remote: " + this.isRemote() + ", origin: " + this.getOrigin() + "]";
        }
    }
}

