/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.common.MiscUtil;
import java.util.Arrays;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ModuleVersionDetails
implements Comparable<ModuleVersionDetails> {
    private String namespace;
    private String module;
    private String version;
    private String doc;
    private String license;
    private boolean remote;
    private String origin;
    private NavigableSet<String> authors = new TreeSet<String>();
    private NavigableSet<ModuleDependencyInfo> dependencies = new TreeSet<ModuleDependencyInfo>();
    private NavigableSet<ModuleVersionArtifact> artifactTypes = new TreeSet<ModuleVersionArtifact>();
    private NavigableSet<String> members = new TreeSet<String>();
    private String groupId;
    private String artifactId;

    public ModuleVersionDetails(String module, String version2, String groupId, String artifactId) {
        this(null, module, version2, groupId, artifactId);
    }

    public ModuleVersionDetails(String namespace, String module, String version2, String groupId, String artifactId) {
        assert (version2 != null);
        this.namespace = namespace;
        this.module = module;
        this.version = version2;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ModuleVersionDetails(String namespace, String module, String version2, String doc, String license, String ... by) {
        this(namespace, module, version2, null, null);
        this.doc = doc;
        this.license = license;
        this.authors.addAll(Arrays.asList(by));
    }

    public ModuleVersionDetails(String namespace, String module, String version2, String groupId, String artifactId, String doc, String license, Set<String> authors, Set<ModuleDependencyInfo> dependencies, Set<ModuleVersionArtifact> artifactTypes, boolean remote, String origin) {
        this(namespace, module, version2, groupId, artifactId);
        this.doc = doc;
        this.license = license;
        this.authors.addAll(authors);
        this.dependencies.addAll(dependencies);
        this.artifactTypes.addAll(artifactTypes);
        this.remote = remote;
        this.origin = origin;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        assert (version2 != null);
        this.version = version2;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public NavigableSet<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(SortedSet<String> authors) {
        this.authors.clear();
        this.authors.addAll(authors);
    }

    public NavigableSet<ModuleDependencyInfo> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(SortedSet<ModuleDependencyInfo> dependencies) {
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    public NavigableSet<ModuleVersionArtifact> getArtifactTypes() {
        return this.artifactTypes;
    }

    public void setArtifactTypes(SortedSet<ModuleVersionArtifact> types) {
        this.artifactTypes.clear();
        this.artifactTypes.addAll(types);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public NavigableSet<String> getMembers() {
        return this.members;
    }

    public void setMembers(Set<String> members) {
        this.members.clear();
        this.members.addAll(members);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (this.namespace != null ? this.namespace.hashCode() : 0);
        hash = 37 * hash + (this.module != null ? this.module.hashCode() : 0);
        hash = 37 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModuleVersionDetails)) {
            return false;
        }
        ModuleVersionDetails other = (ModuleVersionDetails)obj;
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.module, other.module) && Objects.equals(this.version, other.version);
    }

    @Override
    public int compareTo(ModuleVersionDetails o) {
        int result = MiscUtil.compare(this.namespace, o.namespace);
        if (result == 0 && (result = MiscUtil.compare(this.module, o.module)) == 0) {
            result = VersionComparator.compareVersions(this.version, o.version);
        }
        return result;
    }

    public String toString() {
        return "ModuleVersionDetails[ " + this.module + "/" + this.version + ", doc: " + (this.doc != null ? (this.doc.length() > 10 ? this.doc.substring(0, 10) + "..." : this.doc) : null) + ", license: " + this.license + ", by: " + this.authors + ", deps: " + this.dependencies + ", artifacts: " + this.artifactTypes + ", remote: " + this.remote + ", origin: " + this.origin + "]";
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }
}

