/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ArtifactOverrides;
import com.redhat.ceylon.cmr.api.DependencyOverride;
import com.redhat.ceylon.cmr.api.MavenArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ModuleScope;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Overrides {
    private static final Logger log = Logger.getLogger(Overrides.class.getName());
    private Map<ArtifactContext, ArtifactOverrides> overrides = new HashMap<ArtifactContext, ArtifactOverrides>();
    private Map<String, ArtifactOverrides> overridesNoVersion = new HashMap<String, ArtifactOverrides>();
    private Set<DependencyOverride> removed = new HashSet<DependencyOverride>();
    private Set<ArtifactContext> added = new HashSet<ArtifactContext>();
    private Map<ArtifactContext, ArtifactContext> replaced = new HashMap<ArtifactContext, ArtifactContext>();
    private Map<String, ArtifactContext> replacedNoVersion = new HashMap<String, ArtifactContext>();
    private Map<String, String> setVersions = new HashMap<String, String>();
    private String source = null;
    static final String LINE_NUMBER_KEY_NAME = "lineNumber";
    static final String COLUMN_NUMBER_KEY_NAME = "columnNumber";

    private Overrides() {
    }

    public static Overrides create() {
        return new Overrides();
    }

    public static Overrides getDistOverrides() {
        return Overrides.getDistOverrides(true);
    }

    public static Overrides getDistOverrides(boolean upgradeDist) {
        try {
            return Overrides.parseDistOverrides(upgradeDist);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Overrides append(String overridesFileName) throws FileNotFoundException, Exception {
        return Overrides.parse(overridesFileName, this);
    }

    public String toString() {
        return this.source == null ? super.toString() : "Overrides(" + this.source + ")";
    }

    public String getSource() {
        return this.source;
    }

    public void addArtifactOverride(ArtifactOverrides ao) {
        this.overrides.put(ao.getOwner(), ao);
        if (ao.getOwner().getVersion() == null) {
            this.overridesNoVersion.put(ao.getOwner().getName(), ao);
        }
    }

    public ArtifactOverrides getArtifactOverrides(ArtifactContext mc) {
        ArtifactOverrides ao = this.overrides.get(mc);
        if (ao == null) {
            return this.overridesNoVersion.get(mc.getName());
        }
        return ao;
    }

    public void addAddedArtifact(ArtifactContext context) {
        this.added.add(context);
    }

    public void addRemovedArtifact(DependencyOverride context) {
        this.removed.add(context);
    }

    public boolean isRemoved(ArtifactContext context) {
        for (DependencyOverride ro : this.removed) {
            if (!ro.matches(context)) continue;
            return true;
        }
        return false;
    }

    public ArtifactContext getReplacement(ArtifactContext mc) {
        ArtifactContext ao = this.replaced.get(mc);
        if (ao == null) {
            ao = this.replacedNoVersion.get(mc.getName());
        }
        return ao;
    }

    public ArtifactContext replace(ArtifactContext context) {
        ArtifactOverrides artifactOverrides = this.getArtifactOverrides(context);
        if (artifactOverrides != null && artifactOverrides.getReplace() != null) {
            ArtifactContext replacingContext = artifactOverrides.getReplace().getArtifactContext();
            return this.replace(context, replacingContext);
        }
        ArtifactContext replacingContext = this.getReplacement(context);
        if (replacingContext != null) {
            return this.replace(context, replacingContext);
        }
        return null;
    }

    private ArtifactContext replace(ArtifactContext context, ArtifactContext replacingContext) {
        ArtifactContext ret = context.copy();
        ret.setName(replacingContext.getName());
        if (replacingContext.getVersion() != null) {
            ret.setVersion(replacingContext.getVersion());
        } else {
            ret.setVersion(context.getVersion());
        }
        ret.setVersion(this.getVersionOverride(ret));
        ret.setNamespace(replacingContext.getNamespace());
        return ret;
    }

    private void addReplacedArtifact(ArtifactContext context, ArtifactContext withContext) {
        if (context.getVersion() == null) {
            this.replacedNoVersion.put(context.getName(), withContext);
        } else {
            this.replaced.put(context, withContext);
        }
    }

    private void addSetArtifact(ArtifactContext context) {
        this.setVersions.put(context.getName(), context.getVersion());
    }

    public void addSetArtifact(String module, String version2) {
        this.setVersions.put(module, version2);
    }

    public String getVersionOverride(ArtifactContext context) {
        String overriddenVersion = this.setVersions.get(context.getName());
        if (overriddenVersion != null) {
            return overriddenVersion;
        }
        return context.getVersion();
    }

    public boolean isVersionOverridden(ArtifactContext context) {
        return this.setVersions.containsKey(context.getName());
    }

    public ModuleInfo applyOverrides(String module, String version2, ModuleInfo source) {
        ArtifactOverrides artifactOverrides = this.getArtifactOverrides(new ArtifactContext(null, module, version2));
        HashSet<ModuleDependencyInfo> result = new HashSet<ModuleDependencyInfo>();
        for (ModuleDependencyInfo dep : source.getDependencies()) {
            String depNamespace = dep.getNamespace();
            String depName = dep.getName();
            String depVersion = dep.getVersion();
            boolean optional = dep.isOptional();
            boolean export = dep.isExport();
            ModuleScope scope = dep.getModuleScope();
            Backends backends = dep.getNativeBackends();
            ArtifactContext ctx = new ArtifactContext(depNamespace, depName, depVersion);
            if (artifactOverrides != null && artifactOverrides.isRemoved(ctx) || this.isRemoved(ctx) || artifactOverrides != null && artifactOverrides.isAddedOrUpdated(ctx)) continue;
            ArtifactContext replacement = this.replace(ctx);
            if (replacement != null) {
                depNamespace = replacement.getNamespace();
                depName = replacement.getName();
                depVersion = replacement.getVersion();
                ctx = replacement;
            }
            if (this.isVersionOverridden(ctx)) {
                depVersion = this.getVersionOverride(ctx);
            }
            if (artifactOverrides != null) {
                if (artifactOverrides.isShareOverridden(ctx)) {
                    export = artifactOverrides.isShared(ctx);
                }
                if (artifactOverrides.isOptionalOverridden(ctx)) {
                    optional = artifactOverrides.isOptional(ctx);
                }
            }
            result.add(new ModuleDependencyInfo(depNamespace, depName, depVersion, optional, export, backends, scope));
        }
        String filter = source.getFilter();
        if (artifactOverrides != null) {
            if (artifactOverrides.getFilter() != null) {
                filter = artifactOverrides.getFilter();
            }
            for (DependencyOverride add : artifactOverrides.getAdd()) {
                ArtifactContext addContext = add.getArtifactContext();
                result.add(new ModuleDependencyInfo(addContext.getNamespace(), addContext.getName(), addContext.getVersion(), add.isOptional(), add.isShared()));
            }
        }
        return new ModuleInfo(module, version2, source.getGroupId(), source.getArtifactId(), source.getClassifier(), filter, result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Overrides parse(String overridesFileName, Overrides overrides) throws OverrideException {
        File overridesFile = new File(overridesFileName);
        if (!overridesFile.exists()) {
            throw new OverrideNotFoundException("No such overrides file: " + overridesFile);
        }
        try (FileInputStream is = new FileInputStream(overridesFile);){
            Overrides.parse(is, overrides);
            overrides.source = overridesFile.getAbsolutePath();
            Overrides overrides2 = overrides;
            return overrides2;
        }
        catch (InvalidOverrideException e) {
            throw new InvalidOverrideException(e, overridesFileName);
        }
        catch (FileNotFoundException e) {
            throw new OverrideNotFoundException("No such overrides file: " + overridesFile);
        }
        catch (Exception e) {
            throw new OverrideException(e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Overrides parseDistOverrides(boolean upgradeDist) throws OverrideException {
        URL resource = Overrides.class.getResource("/com/redhat/ceylon/cmr/api/dist-overrides.xml");
        try (InputStream is = resource.openStream();){
            List<Element> e;
            String elementName;
            Document document;
            block23: {
                document = Overrides.parseXml(is);
                elementName = upgradeDist ? "dist-upgrade" : "dist-downgrade";
                e = Overrides.getChildren(document.getDocumentElement(), elementName);
                if (e.size() != 1) break block23;
                Overrides overrides = new Overrides();
                Overrides.parseOverrides(overrides, e.get(0));
                overrides.source = resource.toString();
                Overrides overrides2 = overrides;
                {
                    catch (Throwable throwable2) {
                        try {
                            is.close();
                            throw throwable2;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable2;
                    }
                }
                try {
                    is.close();
                    return overrides2;
                }
                catch (IOException iOException) {
                    // empty catch block
                    return overrides2;
                }
            }
            throw new InvalidOverrideException(String.format("Expected exactly one '%s' element in dist-overrides.xml, but found %d", elementName, e.size()), document.getDocumentElement());
        }
        catch (FileNotFoundException e) {
            throw new OverrideNotFoundException("No such overrides file: " + resource);
        }
        catch (Exception e) {
            throw new OverrideException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parse(InputStream is, Overrides result) throws Exception {
        try {
            Document document = Overrides.parseXml(is);
            Element rootElement = document.getDocumentElement();
            Overrides.parseOverrides(result, rootElement);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static void parseOverrides(Overrides result, Element rootElement) throws TransformerException {
        HashMap<String, String> interpolation = new HashMap<String, String>();
        List<Element> defines = Overrides.getChildren(rootElement, "define");
        for (Element define : defines) {
            String name = Overrides.getRequiredAttribute(define, "name", null);
            String value = Overrides.getRequiredAttribute(define, "value", null);
            interpolation.put(name, value);
        }
        List<Element> artifacts = Overrides.getChildren(rootElement, "artifact");
        Overrides.parseArtifacts(artifacts, result, interpolation);
        List<Element> modules = Overrides.getChildren(rootElement, "module");
        Overrides.parseArtifacts(modules, result, interpolation);
        List<Element> removedArtifacts = Overrides.getChildren(rootElement, "remove");
        for (Element artifact : removedArtifacts) {
            ArtifactContext context = Overrides.getArtifactContext(artifact, true, interpolation);
            DependencyOverride doo = new DependencyOverride(context, DependencyOverride.Type.REMOVE, false, false);
            result.addRemovedArtifact(doo);
        }
        List<Element> addedArtifacts = Overrides.getChildren(rootElement, "add");
        for (Element artifact : addedArtifacts) {
            ArtifactContext context = Overrides.getArtifactContext(artifact, false, interpolation);
            result.addAddedArtifact(context);
        }
        List<Element> replacedArtifacts = Overrides.getChildren(rootElement, "replace");
        for (Element artifact : replacedArtifacts) {
            ArtifactContext context = Overrides.getArtifactContext(artifact, true, interpolation);
            List<Element> withs = Overrides.getChildren(artifact, "with");
            for (Element with : withs) {
                ArtifactContext withContext = Overrides.getArtifactContext(with, true, interpolation);
                result.addReplacedArtifact(context, withContext);
            }
        }
        List<Element> setArtifacts = Overrides.getChildren(rootElement, "set");
        for (Element artifact : setArtifacts) {
            ArtifactContext context = Overrides.getArtifactContext(artifact, true, interpolation);
            result.addSetArtifact(context);
        }
    }

    private static void parseArtifacts(List<Element> artifacts, Overrides result, Map<String, String> interpolation) throws TransformerException {
        for (Element artifact : artifacts) {
            List<Element> classifierNode;
            List<Element> versionNode;
            ArtifactContext mc = Overrides.getArtifactContext(artifact, true, interpolation);
            ArtifactOverrides ao = new ArtifactOverrides(mc);
            result.addArtifactOverride(ao);
            Overrides.addOverrides(ao, artifact, DependencyOverride.Type.ADD, interpolation);
            Overrides.addOverrides(ao, artifact, DependencyOverride.Type.REMOVE, interpolation);
            Overrides.addOverrides(ao, artifact, DependencyOverride.Type.REPLACE, interpolation);
            List<Element> filterNode = Overrides.getChildren(artifact, "filter");
            if (filterNode != null && !filterNode.isEmpty()) {
                Node node = filterNode.get(0);
                ao.setFilter(Overrides.interpolate(PathFilterParser.convertNodeToString(node), interpolation));
            }
            if ((versionNode = Overrides.getChildren(artifact, "version")) != null && !versionNode.isEmpty()) {
                Node node = versionNode.get(0);
                ao.setVersion(Overrides.interpolate(node.getTextContent(), interpolation));
            }
            if ((classifierNode = Overrides.getChildren(artifact, "classifier")) != null && !classifierNode.isEmpty()) {
                Node node = classifierNode.get(0);
                ao.setClassifier(Overrides.interpolate(node.getTextContent(), interpolation));
            }
            List<Element> shareArtifacts = Overrides.getChildren(artifact, "share");
            for (Element share : shareArtifacts) {
                ArtifactContext context = Overrides.getArtifactContext(share, true, interpolation);
                ao.addShareOverride(context, true);
            }
            List<Element> unshareArtifacts = Overrides.getChildren(artifact, "unshare");
            for (Element unshare : unshareArtifacts) {
                ArtifactContext context = Overrides.getArtifactContext(unshare, true, interpolation);
                ao.addShareOverride(context, false);
            }
            List<Element> optionalArtifacts = Overrides.getChildren(artifact, "optional");
            for (Element optional : optionalArtifacts) {
                ArtifactContext context = Overrides.getArtifactContext(optional, true, interpolation);
                ao.addOptionalOverride(context, true);
            }
            List<Element> requireArtifacts = Overrides.getChildren(artifact, "require");
            for (Element require : requireArtifacts) {
                ArtifactContext context = Overrides.getArtifactContext(require, true, interpolation);
                ao.addOptionalOverride(context, false);
            }
        }
    }

    public static String interpolate(String string, Map<String, String> interpolation) {
        if (interpolation == null || string == null || string.isEmpty()) {
            return string;
        }
        int firstReplacement = string.indexOf("${");
        if (firstReplacement == -1) {
            return string;
        }
        StringBuffer strbuf = new StringBuffer(string.length());
        int start = 0;
        int[] end = new int[1];
        while (firstReplacement != -1) {
            strbuf.append(string, start, firstReplacement);
            String part = Overrides.replace(string, firstReplacement + 2, end, interpolation);
            strbuf.append(part);
            start = Math.min(end[0] + 1, string.length());
            firstReplacement = string.indexOf("${", start);
        }
        strbuf.append(string, start, string.length());
        return strbuf.toString();
    }

    private static String replace(String string, int start, int[] end, Map<String, String> interpolation) {
        StringBuffer strbufName = new StringBuffer(string.length());
        boolean seenDollar = false;
        for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (seenDollar) {
                if (c == '{') {
                    String replacement = Overrides.replace(string, i + 1, end, interpolation);
                    strbufName.append(replacement);
                    i = end[0];
                    seenDollar = false;
                    continue;
                }
                strbufName.append('$');
            }
            if (c == '$') {
                seenDollar = true;
                continue;
            }
            seenDollar = false;
            if (c == '}') {
                String name = strbufName.toString();
                end[0] = i;
                if ("CEYLON_VERSION".equals(name)) {
                    return "1.3.3";
                }
                if (interpolation.containsKey(name)) {
                    String value = interpolation.get(name);
                    return Overrides.interpolate(value, interpolation);
                }
                return "${" + name + '}';
            }
            strbufName.append(c);
        }
        end[0] = string.length();
        return "${" + strbufName.toString();
    }

    protected static ArtifactContext getArtifactContext(Element element, boolean optionalVersion, Map<String, String> interpolation) {
        String groupId = Overrides.getAttribute(element, "groupId", interpolation);
        if (groupId != null) {
            String artifactId = Overrides.getRequiredAttribute(element, "artifactId", interpolation);
            String version2 = optionalVersion ? Overrides.getAttribute(element, "version", interpolation) : Overrides.getRequiredAttribute(element, "version", interpolation);
            String packaging = Overrides.getAttribute(element, "packaging", interpolation);
            String classifier = Overrides.getAttribute(element, "classifier", interpolation);
            return new MavenArtifactContext(groupId, artifactId, classifier, version2, packaging);
        }
        String moduleUri = Overrides.getRequiredAttribute(element, "module", interpolation);
        String namespace = ModuleUtil.getNamespaceFromUri(moduleUri);
        String module = ModuleUtil.getModuleNameFromUri(moduleUri);
        String version3 = optionalVersion ? Overrides.getAttribute(element, "version", interpolation) : Overrides.getRequiredAttribute(element, "version", interpolation);
        return new ArtifactContext(namespace, module, version3);
    }

    protected static void addOverrides(ArtifactOverrides ao, Element artifact, DependencyOverride.Type type, Map<String, String> interpolation) {
        List<Element> overrides = Overrides.getChildren(artifact, type.name().toLowerCase());
        for (Element override : overrides) {
            NodeList overrideChildren = override.getChildNodes();
            for (int i = 0; i < overrideChildren.getLength(); ++i) {
                Node item = overrideChildren.item(i);
                if (item.getNodeType() != 1) continue;
                throw new InvalidOverrideException(String.format("Element '%s > %s' accepts no child element (seen '%s').", artifact.getTagName(), override.getTagName(), item.getNodeName()), (Element)item);
            }
            ArtifactContext dep = Overrides.getArtifactContext(override, type == DependencyOverride.Type.REMOVE, interpolation);
            boolean shared = Overrides.getBooleanAttribute(override, "shared", interpolation);
            boolean optional = Overrides.getBooleanAttribute(override, "optional", interpolation);
            DependencyOverride doo = new DependencyOverride(dep, type, shared, optional);
            ao.addOverride(doo);
        }
    }

    protected static boolean getBooleanAttribute(Element element, String name, Map<String, String> interpolation) {
        String val = Overrides.getAttribute(element, name, interpolation);
        return val != null && val.toLowerCase().equals("true");
    }

    protected static String getAttribute(Element element, String name, Map<String, String> interpolation) {
        String value = Overrides.interpolate(element.getAttribute(name), interpolation);
        return value == null || value.length() == 0 ? null : value;
    }

    protected static String getRequiredAttribute(Element element, String name, Map<String, String> interpolation) {
        String value = Overrides.getAttribute(element, name, interpolation);
        if (value == null) {
            throw new InvalidOverrideException(String.format("Missing '%s' attribute in element %s.", name, element), element);
        }
        return value;
    }

    protected static Document parseXml(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private Locator locator;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element el = doc.createElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                el.setUserData(Overrides.LINE_NUMBER_KEY_NAME, String.valueOf(this.locator.getLineNumber()), null);
                el.setUserData(Overrides.COLUMN_NUMBER_KEY_NAME, String.valueOf(this.locator.getColumnNumber()), null);
                elementStack.push(el);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedEl = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedEl);
                } else {
                    Element parentEl = (Element)elementStack.peek();
                    parentEl.appendChild(closedEl);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                textBuffer.append(ch, start, length);
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element el = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(textBuffer.toString());
                    el.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }
        };
        parser.parse(inputStream, handler);
        doc.getDocumentElement().normalize();
        return doc;
    }

    private static List<Element> getChildren(Element element, String tagName) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> ret = new ArrayList<Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (item.getNodeType() != 1 || !((Element)item).getTagName().equals(tagName)) continue;
            ret.add((Element)item);
        }
        return ret;
    }

    public ArtifactContext applyOverrides(ArtifactContext sought) {
        ArtifactContext replacedContext = this.replace(sought);
        if (replacedContext == null) {
            replacedContext = sought;
        } else {
            log.fine(this + ": " + sought + " -> " + replacedContext);
        }
        String versionOverride = this.getVersionOverride(replacedContext);
        if (versionOverride != null && !versionOverride.equals(replacedContext.getVersion())) {
            log.fine(this + ": " + replacedContext + " -> version " + versionOverride);
            replacedContext.setVersion(versionOverride);
        }
        return replacedContext;
    }

    public Set<ArtifactContext> getAddedArtifacts() {
        return this.added;
    }

    public static class InvalidOverrideException
    extends OverrideException {
        private static final long serialVersionUID = 1L;
        public int line = -1;
        public int column = -1;

        InvalidOverrideException(String message, Element element) {
            super(message);
            Object data = null;
            data = element.getUserData(Overrides.LINE_NUMBER_KEY_NAME);
            this.line = data == null ? -1 : Integer.parseInt((String)data);
            data = element.getUserData(Overrides.COLUMN_NUMBER_KEY_NAME);
            this.column = data == null ? -1 : Integer.parseInt((String)data);
        }

        private InvalidOverrideException(InvalidOverrideException e, String file) {
            super(file + ":" + e.line + ":" + e.column + ": " + e.getMessage());
            this.line = e.line;
            this.column = e.column;
            this.setStackTrace(e.getStackTrace());
        }
    }

    public static class OverrideNotFoundException
    extends OverrideException {
        private static final long serialVersionUID = 1L;

        public OverrideNotFoundException(String message) {
            super(message);
        }
    }

    public static class OverrideException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public OverrideException(String message) {
            super(message);
        }

        public OverrideException(Exception e) {
            super(e);
        }
    }
}

