/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.spi.ContentTransformer;
import com.redhat.ceylon.cmr.spi.MergeStrategy;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Proxy;
import java.util.List;

public class RepositoryManagerBuilder {
    private static final String PROP_CEYLON_MODULE_RESOLVER_BUILDER = "ceylon.module.resolver.builder";
    private static final String DEFAULT_DELEGATE = "com.redhat.ceylon.cmr.impl.RepositoryManagerBuilderImpl";
    private RepositoryManagerBuilder delegate;

    protected RepositoryManagerBuilder() {
    }

    public RepositoryManagerBuilder(Logger log) {
        this(log, true, 0, Proxy.NO_PROXY, (String)null);
    }

    public RepositoryManagerBuilder(Logger log, String currentDirectory) {
        this(log, true, 0, Proxy.NO_PROXY, currentDirectory);
    }

    public RepositoryManagerBuilder(Logger log, boolean offline, int timeout, Proxy proxy) {
        this(log, offline, timeout, proxy, null, null);
    }

    public RepositoryManagerBuilder(Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory) {
        this(log, offline, timeout, proxy, currentDirectory, null);
    }

    public RepositoryManagerBuilder(Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides) {
        this(log, offline, timeout, proxy, null, overrides, true);
    }

    public RepositoryManagerBuilder(Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory, Overrides overrides) {
        this(log, offline, timeout, proxy, currentDirectory, overrides, true);
    }

    public RepositoryManagerBuilder(Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides, boolean upgradeDist) {
        this(log, offline, timeout, proxy, null, overrides, upgradeDist);
    }

    public RepositoryManagerBuilder(Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory, Overrides overrides, boolean upgradeDist) {
        try {
            Constructor<? extends RepositoryManagerBuilder> ctor = this.getDelegateClass().getConstructor(Logger.class, Boolean.TYPE, Integer.TYPE, Proxy.class, String.class, Overrides.class, Boolean.TYPE);
            this.delegate = ctor.newInstance(log, offline, timeout, proxy, currentDirectory, overrides, upgradeDist);
        }
        catch (InvocationTargetException e) {
            Throwable tex = e.getTargetException();
            if (tex instanceof RuntimeException) {
                throw (RuntimeException)tex;
            }
            throw new IllegalArgumentException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RepositoryManagerBuilder(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy) {
        this(mainRepository, log, offline, timeout, proxy, (String)null);
    }

    public RepositoryManagerBuilder(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory) {
        this(mainRepository, log, offline, timeout, proxy, currentDirectory, null);
    }

    public RepositoryManagerBuilder(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory, Overrides overrides) {
        this(mainRepository, log, offline, timeout, proxy, currentDirectory, overrides, true);
    }

    public RepositoryManagerBuilder(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides) {
        this(mainRepository, log, offline, timeout, proxy, null, overrides, true);
    }

    public RepositoryManagerBuilder(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides, boolean upgradeDist) {
        this(mainRepository, log, offline, timeout, proxy, null, overrides, upgradeDist);
    }

    public RepositoryManagerBuilder(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory, Overrides overrides, boolean upgradeDist) {
        try {
            Constructor<? extends RepositoryManagerBuilder> ctor = this.getDelegateClass().getConstructor(File.class, Logger.class, Boolean.TYPE, Integer.TYPE, Proxy.class, String.class, Overrides.class, Boolean.TYPE);
            this.delegate = ctor.newInstance(mainRepository, log, offline, timeout, proxy, currentDirectory, overrides, upgradeDist);
        }
        catch (InvocationTargetException e) {
            Throwable tex = e.getTargetException();
            if (tex instanceof RuntimeException) {
                throw (RuntimeException)tex;
            }
            throw new IllegalArgumentException(tex);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Class<? extends RepositoryManagerBuilder> getDelegateClass() throws Exception {
        String builderClassName;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((builderClassName = System.getProperty(PROP_CEYLON_MODULE_RESOLVER_BUILDER)) != null && builderClassName.length() > 0) {
            Class<?> clazz = classLoader.loadClass(builderClassName);
            if (!RepositoryManagerBuilder.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(String.format("%s is not an instance of RepositoryManagerBuilder!", clazz.getName()));
            }
            return clazz;
        }
        return classLoader.loadClass(DEFAULT_DELEGATE);
    }

    protected RepositoryManagerBuilder getDelegate() {
        if (this.delegate == null) {
            throw new IllegalArgumentException("Missing method impl / override!");
        }
        return this.delegate;
    }

    public RepositoryBuilder repositoryBuilder() {
        return this.getDelegate().repositoryBuilder();
    }

    public RepositoryManagerBuilder mergeStrategy(MergeStrategy strategy) {
        this.getDelegate().mergeStrategy(strategy);
        return this;
    }

    public RepositoryManagerBuilder contentTransformer(ContentTransformer transformer) {
        this.getDelegate().contentTransformer(transformer);
        return this;
    }

    public RepositoryManagerBuilder cacheContent() {
        this.getDelegate().cacheContent();
        return this;
    }

    public RepositoryManagerBuilder addRepository(CmrRepository external) {
        this.getDelegate().addRepository(external);
        return this;
    }

    public List<String> getRepositoriesDisplayString() {
        return this.getDelegate().getRepositoriesDisplayString();
    }

    public RepositoryManager buildRepository() {
        return this.getDelegate().buildRepository();
    }

    public boolean hasMavenRepository() {
        return this.getDelegate().hasMavenRepository();
    }

    public static Overrides parseOverrides(String overridesFileName) {
        if (overridesFileName != null) {
            try {
                return Overrides.getDistOverrides().append(overridesFileName);
            }
            catch (IllegalArgumentException x) {
                throw x;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

