/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ArtifactCreator;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.RepositoryManagerBuilder;
import com.redhat.ceylon.cmr.api.SourceArtifactCreator;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.impl.CachingRepositoryManager;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.ResourceArtifactCreatorImpl;
import com.redhat.ceylon.cmr.impl.SimpleRepositoryManager;
import com.redhat.ceylon.cmr.impl.SourceArtifactCreatorImpl;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.config.Repositories;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class CeylonUtils {
    public static CeylonRepoManagerBuilder repoManager() {
        return new CeylonRepoManagerBuilder();
    }

    public static SourceArtifactCreator makeSourceArtifactCreator(RepositoryManager repoManager, Iterable<? extends File> sourcePaths, String moduleName, String moduleVersion, boolean verbose, Logger log) throws IOException {
        return new SourceArtifactCreatorImpl(repoManager, sourcePaths, moduleName, moduleVersion, verbose, log);
    }

    public static ArtifactCreator makeResourceArtifactCreator(RepositoryManager repoManager, Iterable<? extends File> sourcePaths, Iterable<? extends File> resourcePaths, String resourceRootName, String moduleName, String moduleVersion, boolean verbose, Logger log) throws IOException {
        return new ResourceArtifactCreatorImpl(repoManager, sourcePaths, resourcePaths, resourceRootName, moduleName, moduleVersion, verbose, log);
    }

    public static <T> boolean arrayContains(T[] array, T item) {
        return Arrays.asList(array).contains(item);
    }

    public static boolean isRemote(String token) {
        return CeylonUtils.isHttp(token) || "mvn".equals(token) || token.startsWith("mvn:") || "aether".equals(token) || token.startsWith("aether:") || token.equals("jdk") || token.equals("jdk:");
    }

    public static boolean isHttp(String token) {
        try {
            URL url = new URL(token);
            String protocol = url.getProtocol();
            return "http".equals(protocol) || "https".equals(protocol);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String resolveRepoUrl(String repoUrl) {
        Repositories repositories = Repositories.get();
        return CeylonUtils.resolveRepoUrl(repositories, repoUrl);
    }

    public static String resolveRepoUrl(Repositories repositories, String repoUrl) {
        String path;
        Repositories.Repository repo;
        if (repoUrl.startsWith("+") && (repo = repositories.getRepository(path = repoUrl.substring(1))) != null) {
            repoUrl = repo.getUrl();
        }
        return repoUrl;
    }

    public static class CeylonRepoManagerBuilder {
        private static final String WEBDAV_CONTENT_STORE_CLASS = "com.redhat.ceylon.cmr.webdav.WebDAVContentStore";
        private CeylonConfig config;
        private File actualCwd;
        private File cwd;
        private String systemRepo;
        private String cacheRepo;
        private String overrides;
        private List<String> userRepos;
        private List<String> extraUserRepos;
        private List<String> remoteRepos;
        private String outRepo;
        private String user;
        private String password;
        private int timeout = -1;
        private Proxy proxy;
        private boolean offline;
        private boolean noSystemRepo;
        private boolean noCacheRepo;
        private boolean noOutRepo;
        private boolean noDefRepos;
        private boolean jdkIncluded;
        private Logger log;
        private boolean skipRemoteRepositories;
        private boolean upgradeDist = true;

        public CeylonRepoManagerBuilder config(CeylonConfig config) {
            this.config = config;
            return this;
        }

        public CeylonRepoManagerBuilder cwd(File cwd) {
            this.cwd = cwd;
            return this;
        }

        public CeylonRepoManagerBuilder cwd(String cwd) {
            this.cwd = cwd != null ? new File(cwd) : null;
            return this;
        }

        public CeylonRepoManagerBuilder systemRepo(String systemRepo) {
            this.systemRepo = systemRepo;
            return this;
        }

        public CeylonRepoManagerBuilder cacheRepo(String cacheRepo) {
            this.cacheRepo = cacheRepo;
            return this;
        }

        public CeylonRepoManagerBuilder overrides(String overrides) {
            this.overrides = overrides;
            return this;
        }

        public CeylonRepoManagerBuilder noSystemRepo(boolean noSystemRepo) {
            this.noSystemRepo = noSystemRepo;
            return this;
        }

        public CeylonRepoManagerBuilder noCacheRepo(boolean noCacheRepo) {
            this.noCacheRepo = noCacheRepo;
            return this;
        }

        public CeylonRepoManagerBuilder noOutRepo(boolean noOutRepo) {
            this.noOutRepo = noOutRepo;
            return this;
        }

        public CeylonRepoManagerBuilder noDefaultRepos(boolean noDefRepos) {
            this.noDefRepos = noDefRepos;
            return this;
        }

        public CeylonRepoManagerBuilder remoteRepos(List<String> remoteRepos) {
            this.remoteRepos = remoteRepos;
            return this;
        }

        public CeylonRepoManagerBuilder userRepos(List<String> userRepos) {
            this.userRepos = userRepos;
            return this;
        }

        public CeylonRepoManagerBuilder extraUserRepos(List<String> extraUserRepos) {
            this.extraUserRepos = extraUserRepos;
            return this;
        }

        public CeylonRepoManagerBuilder outRepo(String outRepo) {
            this.outRepo = outRepo;
            return this;
        }

        public String getResolvedOutRepo() {
            return this.outRepo;
        }

        public CeylonRepoManagerBuilder user(String user) {
            this.user = user;
            return this;
        }

        public CeylonRepoManagerBuilder password(String password) {
            this.password = password;
            return this;
        }

        public CeylonRepoManagerBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public CeylonRepoManagerBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public CeylonRepoManagerBuilder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public CeylonRepoManagerBuilder isJDKIncluded(boolean include) {
            this.jdkIncluded = include;
            return this;
        }

        public CeylonRepoManagerBuilder logger(Logger logger) {
            this.log = logger;
            return this;
        }

        public RepositoryManager buildManager() {
            return this.buildManagerBuilder().buildRepository();
        }

        public RepositoryManagerBuilder buildManagerBuilder() {
            Repositories.Repository[] repos;
            File root;
            if (this.log == null) {
                this.log = new CMRJULLogger();
            }
            this.actualCwd = new File(".");
            if (this.config == null) {
                if (this.cwd == null || this.actualCwd.equals(this.cwd)) {
                    this.cwd = this.actualCwd;
                    this.config = CeylonConfig.get();
                } else {
                    this.config = CeylonConfig.createFromLocalDir(this.cwd);
                }
            } else if (this.cwd == null) {
                this.cwd = this.actualCwd;
            }
            Repositories repositories = Repositories.withConfig(this.config);
            if (this.cacheRepo == null) {
                Repositories.Repository cr = repositories.getCacheRepository();
                root = new File(this.absolute(cr.getUrl()));
            } else {
                root = new File(this.absolute(CeylonUtils.resolveRepoUrl(repositories, this.cacheRepo)));
            }
            if (this.noCacheRepo || this.avoidRepository(root.getAbsolutePath())) {
                root = null;
                this.skipRemoteRepositories = true;
            }
            RepositoryManagerBuilder builder = new RepositoryManagerBuilder(root, this.log, this.isOffline(this.config), this.getTimeout(this.config), this.getProxy(this.config), this.getOverrides(this.config), this.upgradeDist);
            if (this.systemRepo == null) {
                if (!this.noSystemRepo) {
                    this.addRepo(builder, repositories.getSystemRepository());
                }
            } else {
                this.addRepo(builder, repositories, this.systemRepo);
            }
            if (!this.noOutRepo) {
                if (this.outRepo == null) {
                    if (!this.noDefRepos) {
                        this.addRepo(builder, repositories.getOutputRepository());
                    }
                } else {
                    this.addRepo(builder, repositories, this.outRepo);
                }
            }
            if (this.jdkIncluded) {
                this.addRepo(builder, repositories, "jdk");
            }
            if (this.userRepos != null && !this.userRepos.isEmpty()) {
                for (String repo : this.userRepos) {
                    this.addRepo(builder, repositories, repo);
                }
            } else if (!this.noDefRepos) {
                for (Repositories.Repository lookup : repos = repositories.getLocalLookupRepositories()) {
                    this.addRepo(builder, lookup);
                }
            }
            if (this.extraUserRepos != null && !this.extraUserRepos.isEmpty()) {
                for (String repo : this.extraUserRepos) {
                    this.addRepo(builder, repositories, repo);
                }
            }
            if (!this.noDefRepos) {
                Repositories.Repository[] globals = repositories.getGlobalLookupRepositories();
                for (Repositories.Repository lookup : globals) {
                    this.addRepo(builder, lookup);
                }
            }
            if (this.remoteRepos != null && !this.remoteRepos.isEmpty()) {
                for (String repo : this.remoteRepos) {
                    this.addRepo(builder, repositories, repo);
                }
            } else if (!this.noDefRepos) {
                for (Repositories.Repository lookup : repos = repositories.getRemoteLookupRepositories()) {
                    this.addRepo(builder, lookup);
                }
            }
            if (!this.noDefRepos) {
                Repositories.Repository[] others = repositories.getOtherLookupRepositories();
                for (Repositories.Repository lookup : others) {
                    this.addRepo(builder, lookup);
                }
            }
            this.log.debug("Repository lookup order:");
            for (String rds : builder.getRepositoriesDisplayString()) {
                this.log.debug(" - " + rds);
            }
            return builder;
        }

        public RepositoryManager buildOutputManager() {
            Repositories.Repository repo;
            if (this.log == null) {
                this.log = new CMRJULLogger();
            }
            this.actualCwd = new File(".");
            if (this.config == null) {
                if (this.cwd == null || this.actualCwd.equals(this.cwd)) {
                    this.cwd = this.actualCwd;
                    this.config = CeylonConfig.get();
                } else {
                    this.config = CeylonConfig.createFromLocalDir(this.cwd);
                }
            } else if (this.cwd == null) {
                this.cwd = this.actualCwd;
            }
            Repositories repositories = Repositories.withConfig(this.config);
            if (this.outRepo == null) {
                repo = repositories.getOutputRepository();
                this.outRepo = repo.getUrl();
                if (this.user == null && repo.getCredentials() != null) {
                    this.user = repo.getCredentials().getUser();
                }
                if (this.password == null && repo.getCredentials() != null) {
                    this.password = repo.getCredentials().getPassword();
                }
            } else if (this.outRepo.startsWith("+") && (repo = repositories.getRepository(this.outRepo.substring(1))) != null) {
                this.outRepo = repo.getUrl();
            }
            String key = this.outRepo.startsWith("${") ? this.outRepo.substring(2, this.outRepo.length() - 1) : this.outRepo;
            String temp = System.getProperty(key);
            if (temp != null) {
                this.outRepo = temp;
            }
            if (!CeylonUtils.isHttp(this.outRepo)) {
                this.outRepo = this.absolute(this.outRepo);
                File repoFolder = new File(this.outRepo);
                if (repoFolder.exists()) {
                    if (!repoFolder.isDirectory()) {
                        this.log.error("Output repository is not a directory: " + this.outRepo);
                    } else if (!repoFolder.canWrite()) {
                        this.log.error("Output repository is not writable: " + this.outRepo);
                    }
                } else if (!FileUtil.mkdirs(repoFolder)) {
                    this.log.error("Failed to create output repository: " + this.outRepo);
                }
                FileContentStore structureBuilder = new FileContentStore(repoFolder);
                return new SimpleRepositoryManager(structureBuilder, this.log);
            }
            File cachingDir = FileUtil.makeTempDir("ceylon-webdav-cache-");
            try {
                Class<?> klass = Class.forName(WEBDAV_CONTENT_STORE_CLASS);
                Constructor<?> constructor = klass.getConstructor(String.class, Logger.class, Boolean.TYPE, Integer.TYPE, Proxy.class, String.class, String.class);
                StructureBuilder contentStore = (StructureBuilder)constructor.newInstance(this.outRepo, this.log, false, this.getTimeout(this.config), this.getProxy(this.config), this.user, this.password);
                return new CachingRepositoryManager(contentStore, cachingDir, this.log);
            }
            catch (LinkageError e) {
                throw new RuntimeException("Failed to initialise WebDAV content store: missing Sardine module?", e);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Failed to initialise WebDAV content store", e);
            }
        }

        private boolean avoidRepository(String path) {
            return this.skipRemoteRepositories && CeylonUtils.isRemote(path);
        }

        private void addRepo(RepositoryManagerBuilder builder, Repositories.Repository repoInfo) {
            if (repoInfo != null) {
                this.addRepo(builder, repoInfo.getUrl());
            }
        }

        private void addRepo(RepositoryManagerBuilder builder, Repositories repositories, String repoUrl) {
            repoUrl = CeylonUtils.resolveRepoUrl(repositories, repoUrl);
            this.addRepo(builder, repoUrl);
        }

        private void addRepo(RepositoryManagerBuilder builder, String repoUrl) {
            try {
                String path = builder.repositoryBuilder().absolute(this.cwd, repoUrl);
                if (!this.avoidRepository(path)) {
                    CmrRepository[] repos;
                    RepositoryBuilder.RepositoryBuilderConfig cfg = new RepositoryBuilder.RepositoryBuilderConfig(this.log, this.isOffline(this.config), this.getTimeout(this.config), this.getProxy(this.config), this.cwd.getAbsolutePath());
                    for (CmrRepository repo : repos = builder.repositoryBuilder().buildRepository(path, cfg)) {
                        builder.addRepository(repo);
                    }
                }
            }
            catch (Exception e) {
                this.log.debug("Failed to add repository as input repository: " + repoUrl + ": " + e.getMessage());
            }
        }

        private String absolute(String path) {
            String prefix = null;
            if (path.startsWith("flat:")) {
                prefix = "flat:";
                path = path.substring(5);
            }
            if (!CeylonUtils.isRemote(path)) {
                File f = FileUtil.absoluteFile(FileUtil.applyCwd(this.cwd, new File(path)));
                path = f.getAbsolutePath();
            }
            if (prefix == null) {
                return path;
            }
            return prefix + path;
        }

        private boolean isOffline(CeylonConfig config) {
            return this.offline || DefaultToolOptions.getDefaultOffline(config);
        }

        private int getTimeout(CeylonConfig config) {
            return this.timeout >= 0 ? this.timeout : (int)DefaultToolOptions.getDefaultTimeout(config);
        }

        private Proxy getProxy(CeylonConfig config) {
            return this.proxy != null ? this.proxy : DefaultToolOptions.getDefaultProxy(config);
        }

        protected Overrides getOverrides(CeylonConfig config) {
            String path = this.overrides != null ? this.overrides : DefaultToolOptions.getDefaultOverrides(config);
            return this.getOverrides(path);
        }

        protected Overrides getOverrides(String path) {
            if (path != null) {
                File f = FileUtil.absoluteFile(FileUtil.applyCwd(this.cwd, new File(path)));
                return this.getOverrides(f);
            }
            return null;
        }

        protected Overrides getOverrides(File f) {
            return RepositoryManagerBuilder.parseOverrides(f.getPath());
        }

        public CeylonRepoManagerBuilder upgradeDist(boolean upgradeDist) {
            this.upgradeDist = upgradeDist;
            return this;
        }
    }
}

