/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.ClassFileScanner;
import com.redhat.ceylon.cmr.ceylon.ShaSigner;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.impl.JarUtils;
import com.redhat.ceylon.cmr.impl.PropertiesDependencyResolver;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.JdkProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class LegacyImporter {
    private final String moduleName;
    private final String moduleVersion;
    private final File jarFile;
    private final File sourceJarFile;
    private final RepositoryManager outRepoman;
    private final RepositoryManager lookupRepoman;
    private final ImporterFeedback feedback;
    private final Logger log;
    private final JdkProvider jdkProvider;
    private File descriptorFile;
    private Set<ModuleDependencyInfo> expectedDependencies;
    private Map<String, List<Pattern>> missingDependenciesPackages;
    private boolean descriptorLoaded;
    private boolean hasProblems;
    private boolean hasErrors;
    private ClassFileScanner scanner;
    private boolean ignoreAnnotations;

    public LegacyImporter(String moduleName, String moduleVersion, File jarFile, RepositoryManager outputRepository, RepositoryManager lookupRepository) {
        this(moduleName, moduleVersion, jarFile, outputRepository, lookupRepository, null);
    }

    public LegacyImporter(String moduleName, String moduleVersion, File jarFile, RepositoryManager outputRepository, RepositoryManager lookupRepository, ImporterFeedback feedback) {
        this(moduleName, moduleVersion, jarFile, null, outputRepository, lookupRepository, new CMRJULLogger(), feedback);
    }

    public LegacyImporter(String moduleName, String moduleVersion, File jarFile, File sourceJarFile, RepositoryManager outputRepository, RepositoryManager lookupRepository, Logger log, ImporterFeedback feedback) {
        assert (jarFile != null);
        assert (outputRepository != null);
        assert (lookupRepository != null);
        assert (log != null);
        this.moduleName = moduleName;
        this.moduleVersion = moduleVersion;
        this.jarFile = jarFile;
        this.sourceJarFile = sourceJarFile;
        this.outRepoman = outputRepository;
        this.lookupRepoman = lookupRepository;
        this.log = log;
        this.feedback = feedback;
        this.jdkProvider = new JdkProvider();
    }

    public boolean hasProblems() {
        return this.hasProblems;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public LegacyImporter missingDependenciesPackages(Map<String, List<String>> missingDependenciesPackages) {
        if (missingDependenciesPackages == null) {
            return this;
        }
        this.missingDependenciesPackages = new HashMap<String, List<Pattern>>();
        for (Map.Entry<String, List<String>> entry : missingDependenciesPackages.entrySet()) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>(entry.getValue().size());
            for (String pkg : entry.getValue()) {
                String regex = LegacyImporter.wildcardToRegex(pkg);
                Pattern pattern = Pattern.compile(regex);
                patterns.add(pattern);
            }
            this.missingDependenciesPackages.put(entry.getKey(), patterns);
        }
        return this;
    }

    public LegacyImporter moduleDescriptor(File descriptorFile) {
        this.descriptorFile = descriptorFile;
        return this;
    }

    public LegacyImporter loadModuleDescriptor() throws Exception {
        if (this.descriptorFile != null && !this.descriptorLoaded) {
            ModuleInfo moduleInfo = null;
            if (this.descriptorFile.exists()) {
                if (this.descriptorFile.toString().toLowerCase().endsWith(".xml")) {
                    moduleInfo = XmlDependencyResolver.INSTANCE.resolveFromFile(this.descriptorFile, this.moduleName, this.moduleVersion, this.lookupRepoman.getOverrides());
                } else if (this.descriptorFile.toString().toLowerCase().endsWith(".properties")) {
                    moduleInfo = PropertiesDependencyResolver.INSTANCE.resolveFromFile(this.descriptorFile, this.moduleName, this.moduleVersion, this.lookupRepoman.getOverrides());
                }
                this.descriptorLoaded = true;
            }
            this.gatherExternalClasses(moduleInfo);
            if (moduleInfo != null) {
                this.checkModuleDescriptor(moduleInfo);
            }
        }
        return this;
    }

    public LegacyImporter listPackages(boolean makeSuggestions) throws Exception {
        this.gatherExternalClasses(null);
        if (this.scanner.hasExternalClasses()) {
            Set<String> externalPackages = this.scanner.getExternalPackages();
            Set<String> publicApiExternalPackages = this.scanner.getPublicApiExternalPackages();
            if (!externalPackages.isEmpty()) {
                Set<String> jdkModules = this.scanner.gatherJdkModules(externalPackages);
                Set<String> publicApiJdkModules = this.scanner.gatherJdkModules(publicApiExternalPackages);
                if (jdkModules.contains("java.base") && !publicApiJdkModules.contains("java.base")) {
                    jdkModules.remove("java.base");
                }
                if (!jdkModules.isEmpty()) {
                    this.feedback.beforeJdkModules();
                    for (String mod : jdkModules) {
                        ModuleDependencyInfo dep = new ModuleDependencyInfo(null, mod, this.jdkProvider.getJDKVersion(), false, publicApiJdkModules.contains(mod), Backends.JAVA);
                        this.feedback.dependency(DependencyResults.DEP_JDK, dep);
                        this.expectedDependencies.add(dep);
                    }
                    this.feedback.afterJdkModules();
                }
                if (!externalPackages.isEmpty()) {
                    this.feedback.beforePackages();
                    for (String pkg : externalPackages) {
                        this.feedback.packageName(pkg, publicApiExternalPackages.contains(pkg));
                        if (!makeSuggestions) continue;
                        this.outputSuggestions(pkg);
                    }
                    this.hasErrors = true;
                    this.feedback.afterPackages();
                }
            }
            Set<String> externalDefaultClasses = this.scanner.getDefaultPackageClasses();
            Set<String> publicApiExternalDefaultClasses = this.scanner.getPublicApiDefaultPackageClasses();
            if (!externalDefaultClasses.isEmpty()) {
                this.feedback.beforeClasses();
                for (String cls : externalDefaultClasses) {
                    this.feedback.className(cls, publicApiExternalDefaultClasses.contains(cls));
                }
                this.hasErrors = true;
                this.feedback.afterClasses();
            }
        }
        return this;
    }

    public LegacyImporter listClasses() throws Exception {
        this.gatherExternalClasses(null);
        if (this.scanner.hasExternalClasses()) {
            this.feedback.beforeClasses();
            for (String cls : this.scanner.getExternalClasses()) {
                this.feedback.className(cls, this.scanner.getPublicApiExternalClasses().contains(cls));
            }
            this.hasErrors = true;
            this.feedback.afterClasses();
        }
        return this;
    }

    public LegacyImporter updateModuleDescriptor() throws IOException {
        if (this.hasProblems && this.descriptorFile != null) {
            if (this.descriptorFile.toString().toLowerCase().endsWith(".xml")) {
                this.updateDescriptorXml();
            } else if (this.descriptorFile.toString().toLowerCase().endsWith(".properties")) {
                this.updateDescriptorProperties();
            }
        }
        return this;
    }

    public LegacyImporter publish() {
        ArtifactContext context = new ArtifactContext(null, this.moduleName, this.moduleVersion, ".jar");
        context.setForceOperation(true);
        this.outRepoman.putArtifact(context, this.jarFile);
        ShaSigner.signArtifact(this.outRepoman, context, this.jarFile, this.log);
        if (this.sourceJarFile != null) {
            ArtifactContext sourceJarContext = new ArtifactContext(null, this.moduleName, this.moduleVersion, "-sources.jar");
            context.setForceOperation(true);
            this.outRepoman.putArtifact(sourceJarContext, this.sourceJarFile);
            ShaSigner.signArtifact(this.outRepoman, sourceJarContext, this.sourceJarFile, this.log);
        }
        if (this.descriptorFile != null) {
            ArtifactContext descriptorContext = null;
            if (this.descriptorFile.toString().toLowerCase().endsWith(".xml")) {
                descriptorContext = new ArtifactContext(null, this.moduleName, this.moduleVersion, "module.xml");
            } else if (this.descriptorFile.toString().toLowerCase().endsWith(".properties")) {
                descriptorContext = new ArtifactContext(null, this.moduleName, this.moduleVersion, "module.properties");
            }
            descriptorContext.setForceOperation(true);
            this.outRepoman.putArtifact(descriptorContext, this.descriptorFile);
            ShaSigner.signArtifact(this.outRepoman, descriptorContext, this.descriptorFile, this.log);
        }
        return this;
    }

    private void checkModuleDescriptor(ModuleInfo dependencies) throws Exception {
        this.feedback.beforeDependencies();
        HashSet<String> visited = new HashSet<String>();
        this.checkDependencies(dependencies.getDependencies(), visited);
        this.feedback.afterDependencies();
    }

    private void checkDependencies(Set<ModuleDependencyInfo> dependencies, Set<String> visited) throws Exception {
        if (!dependencies.isEmpty()) {
            TreeSet<ModuleDependencyInfo> sortedDeps = new TreeSet<ModuleDependencyInfo>(dependencies);
            this.checkDependencies(sortedDeps, visited, true);
            this.checkDependencies(sortedDeps, visited, false);
        }
    }

    private void checkDependencies(TreeSet<ModuleDependencyInfo> sortedDeps, Set<String> visited, boolean exported) throws Exception {
        for (ModuleDependencyInfo dep : sortedDeps) {
            if (exported != dep.isExport() || dep.getModuleScope() == ModuleScope.TEST || !visited.add(dep.getModuleName())) continue;
            this.feedback.beforeDependency(dep);
            String name = dep.getName();
            String version2 = dep.getVersion();
            if (name == null || name.isEmpty()) {
                this.feedback.dependencyError(DependencyErrors.DEPERR_INVALID_MODULE_NAME, dep);
            }
            if (ModuleUtil.isDefaultModule(name)) {
                this.feedback.dependencyError(DependencyErrors.DEPERR_INVALID_MODULE_DEFAULT, dep);
            }
            if (version2 == null || version2.isEmpty()) {
                this.feedback.dependencyError(DependencyErrors.DEPERR_INVALID_MODULE_VERSION, dep);
            }
            ClassFileScanner.Usage usage = null;
            if (this.jdkProvider.isJDKModule(name)) {
                usage = this.scanner.removeMatchingJdkClasses(name);
            } else {
                File artifact;
                ArtifactContext context = new ArtifactContext(dep.getNamespace(), name, version2, ".car", ".jar");
                ArtifactResult result = this.lookupRepoman.getArtifactResult(context);
                File file = artifact = result != null ? result.artifact() : null;
                if (artifact != null && artifact.exists()) {
                    try {
                        Set<String> importedClasses = JarUtils.gatherClassnamesFromJar(artifact);
                        this.addTransitiveDependenciesClasses(result, importedClasses, visited, dep);
                        usage = this.scanner.removeMatchingClasses(importedClasses);
                    }
                    catch (IOException e) {
                        this.feedback.dependency(DependencyResults.DEP_CHECK_FAILED, dep);
                        this.hasErrors = true;
                    }
                } else {
                    if (dep.isOptional()) {
                        String key = ModuleUtil.makeModuleName(dep.getName(), dep.getVersion());
                        if (this.missingDependenciesPackages != null && this.missingDependenciesPackages.containsKey(key)) {
                            List<Pattern> packages = this.missingDependenciesPackages.get(key);
                            usage = this.scanner.removeMatchingPackages(packages);
                        }
                    }
                    if (usage == null) {
                        this.feedback.dependency(DependencyResults.DEP_NOT_FOUND, dep);
                        this.hasErrors = true;
                    }
                }
            }
            if (usage != null) {
                switch (usage) {
                    case Used: {
                        if (!dep.isExport()) {
                            this.feedback.dependency(DependencyResults.DEP_OK, dep);
                            break;
                        }
                        dep = new ModuleDependencyInfo(null, dep.getName(), dep.getVersion(), dep.isOptional(), false, dep.getNativeBackends(), dep.getModuleScope());
                        this.feedback.dependency(DependencyResults.DEP_MARK_UNSHARED, dep);
                        break;
                    }
                    case UsedInPublicApi: {
                        if (dep.isExport()) {
                            this.feedback.dependency(DependencyResults.DEP_OK, dep);
                            break;
                        }
                        dep = new ModuleDependencyInfo(null, dep.getName(), dep.getVersion(), dep.isOptional(), true, dep.getNativeBackends(), dep.getModuleScope());
                        this.feedback.dependency(DependencyResults.DEP_MARK_SHARED, dep);
                        this.hasProblems = true;
                        break;
                    }
                    default: {
                        dep = new ModuleDependencyInfo(null, dep.getName(), dep.getVersion(), dep.isOptional(), false, dep.getNativeBackends(), dep.getModuleScope());
                        this.feedback.dependency(DependencyResults.DEP_OK_UNUSED, dep);
                    }
                }
            }
            this.feedback.afterDependency(dep);
            this.expectedDependencies.add(dep);
        }
    }

    private void addTransitiveDependenciesClasses(ArtifactResult result, Set<String> classes, Set<String> visited, ModuleDependencyInfo originalDependency) throws Exception {
        this.log.info("Visiting transitive dependencies for " + result.name() + "/" + result.version());
        try {
            for (ArtifactResult dep : result.dependencies()) {
                if (dep.moduleScope() == ModuleScope.TEST || !dep.exported() || !visited.add(dep.name() + "/" + dep.version())) continue;
                String name = dep.name();
                if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version)) {
                    name = JDKUtils.getJava9ModuleName(name, dep.version());
                }
                if (this.jdkProvider.isJDKModule(name)) continue;
                this.log.info(" dep " + dep.name() + "/" + dep.version());
                ArtifactContext context = new ArtifactContext(dep.namespace(), dep.name(), dep.version(), ".car", ".jar");
                ArtifactResult depResult = this.lookupRepoman.getArtifactResult(context);
                File artifact = depResult != null ? depResult.artifact() : null;
                this.log.info("Result: " + depResult);
                if (artifact != null && artifact.exists()) {
                    try {
                        Set<String> importedClasses = JarUtils.gatherClassnamesFromJar(artifact);
                        classes.addAll(importedClasses);
                        this.addTransitiveDependenciesClasses(depResult, classes, visited, originalDependency);
                    }
                    catch (IOException x) {
                        this.feedback.dependency(DependencyResults.DEP_TRANSITIVE_ERROR, originalDependency);
                        this.hasErrors = true;
                    }
                    continue;
                }
                this.feedback.dependency(DependencyResults.DEP_TRANSITIVE_ERROR, originalDependency);
                this.hasErrors = true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuffer strbuf = new StringBuffer(wildcard.length());
        char[] chars = wildcard.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '?') {
                strbuf.append('.');
                continue;
            }
            if (c == '*') {
                char next;
                if (i + 1 < chars.length && (next = chars[i + 1]) == '*') {
                    strbuf.append(".*");
                    ++i;
                    continue;
                }
                strbuf.append("[^.]*");
                continue;
            }
            strbuf.append("\\Q").append(c).append("\\E");
        }
        String ret = strbuf.toString();
        if (ret.endsWith("\\Q.\\E.*")) {
            ret = ret.substring(0, ret.length() - 7) + "(\\Q.\\E.*)?";
        }
        return ret;
    }

    private void gatherExternalClasses(ModuleInfo moduleInfo) throws MalformedURLException, IOException {
        if (this.scanner == null) {
            if (!this.jarFile.isFile()) {
                throw new FileNotFoundException("Could not find " + this.jarFile);
            }
            this.scanner = new ClassFileScanner(this.jarFile, this.ignoreAnnotations, this.jdkProvider);
            this.expectedDependencies = new HashSet<ModuleDependencyInfo>();
            this.scanner.scan(moduleInfo);
        }
    }

    private void outputSuggestions(String pkg) throws Exception {
        ModuleDependencyInfo dep = null;
        Set<ModuleSearchResult.ModuleDetails> suggestions = this.findSuggestions(pkg);
        if (!suggestions.isEmpty() && (dep = this.feedback.suggestions(pkg, suggestions)) != null) {
            this.expectedDependencies.add(dep);
            this.hasProblems = true;
        }
    }

    private Set<ModuleSearchResult.ModuleDetails> findSuggestions(String pkg) {
        TreeSet<ModuleSearchResult.ModuleDetails> suggestions = new TreeSet<ModuleSearchResult.ModuleDetails>();
        ModuleVersionQuery query = new ModuleVersionQuery(null, "", null, ModuleQuery.Type.JVM);
        query.setJvmBinaryMajor(8);
        query.setJvmBinaryMinor(1);
        query.setMemberName(pkg);
        query.setMemberSearchExact(true);
        query.setMemberSearchPackageOnly(true);
        ModuleSearchResult result = this.lookupRepoman.completeModules(query);
        for (ModuleSearchResult.ModuleDetails mvd : result.getResults()) {
            suggestions.add(mvd);
        }
        return suggestions;
    }

    private void updateDescriptorProperties() throws IOException {
        Properties deps = new Properties();
        for (ModuleDependencyInfo mdi : this.expectedDependencies) {
            String key = mdi.getName();
            String val = mdi.getVersion();
            if (mdi.isExport()) {
                key = "+" + key;
            }
            if (mdi.isOptional()) {
                key = key + "?";
            }
            deps.setProperty(key, val);
        }
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.descriptorFile), "UTF-8");){
            deps.store(out, "Generated by 'ceylon import-jar'");
        }
    }

    private void updateDescriptorXml() throws IOException {
        throw new RuntimeException("Updating of .xml module descriptors not supported");
    }

    public boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public static interface ImporterFeedback {
        public void beforeDependencies() throws Exception;

        public void beforeDependency(ModuleDependencyInfo var1) throws Exception;

        public void dependency(DependencyResults var1, ModuleDependencyInfo var2) throws Exception;

        public void dependencyError(DependencyErrors var1, ModuleDependencyInfo var2) throws Exception;

        public void afterDependency(ModuleDependencyInfo var1) throws Exception;

        public void afterDependencies() throws Exception;

        public void beforeJdkModules() throws Exception;

        public void afterJdkModules() throws Exception;

        public void beforePackages() throws Exception;

        public void packageName(String var1, boolean var2) throws Exception;

        public ModuleDependencyInfo suggestions(String var1, Set<ModuleSearchResult.ModuleDetails> var2) throws Exception;

        public void afterPackages() throws Exception;

        public void beforeClasses() throws Exception;

        public void className(String var1, boolean var2) throws Exception;

        public void afterClasses() throws Exception;
    }

    public static enum DependencyErrors {
        DEPERR_INVALID_MODULE_NAME,
        DEPERR_INVALID_MODULE_VERSION,
        DEPERR_INVALID_MODULE_DEFAULT;

    }

    public static enum DependencyResults {
        DEP_OK,
        DEP_OK_UNUSED,
        DEP_MARK_SHARED,
        DEP_MARK_UNSHARED,
        DEP_NOT_FOUND,
        DEP_CHECK_FAILED,
        DEP_JDK,
        DEP_TRANSITIVE_ERROR;

    }
}

